/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.manager;

import java.util.HashMap;
import java.util.Map;
import studio.magemonkey.fabled.data.formula.Formula;
import studio.magemonkey.fabled.data.formula.value.CustomValue;
import studio.magemonkey.fabled.dynamic.EffectComponent;
import studio.magemonkey.fabled.log.LogType;
import studio.magemonkey.fabled.log.Logger;

public class AttributeValue {
    private Formula formula;
    private Map<String, String> conditions = new HashMap<String, String>();

    public AttributeValue(String data) {
        String[] pieces = data.split(":");
        this.formula = new Formula(pieces[0], new CustomValue("v"), new CustomValue("a"));
        for (int i = 1; i < pieces.length; ++i) {
            String[] sides = pieces[i].split("=");
            this.conditions.put(sides[0], sides[1]);
            Logger.log(LogType.ATTRIBUTE_LOAD, 3, "      Condition: " + sides[0] + " / " + sides[1]);
        }
    }

    public boolean passes(EffectComponent component) {
        for (String key : this.conditions.keySet()) {
            if (component.getSettings().getString(key).equalsIgnoreCase(this.conditions.get(key))) continue;
            return false;
        }
        return true;
    }

    public double apply(double value, int amount) {
        return this.formula.compute(value, amount);
    }
}

