/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.listener;

import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.registry.BuffRegistry;
import studio.magemonkey.fabled.api.event.BuffExpiredEvent;
import studio.magemonkey.fabled.api.event.PhysicalDamageEvent;
import studio.magemonkey.fabled.api.event.SkillDamageEvent;
import studio.magemonkey.fabled.api.event.SkillHealEvent;
import studio.magemonkey.fabled.api.util.BuffManager;
import studio.magemonkey.fabled.api.util.BuffType;
import studio.magemonkey.fabled.hook.PluginChecker;
import studio.magemonkey.fabled.listener.FabledListener;
import studio.magemonkey.fabled.listener.PacketListener;

public class BuffListener
extends FabledListener {
    private static double scaleDamage(@Nullable LivingEntity damager, @NotNull LivingEntity target, double damage, @Nullable String classification) {
        Object damageType = BuffType.DAMAGE.getLocalizedName();
        Object defenseType = BuffType.DEFENSE.getLocalizedName();
        if (classification != null && !classification.equalsIgnoreCase("physical")) {
            damageType = BuffType.SKILL_DAMAGE.getLocalizedName() + "_" + classification;
            defenseType = BuffType.SKILL_DEFENSE.getLocalizedName() + "_" + classification;
        }
        double withDamageBuffs = damage;
        if (damager != null) {
            withDamageBuffs = BuffRegistry.scaleValue((String)damageType, (LivingEntity)damager, (double)damage);
        }
        return BuffRegistry.scaleValue((String)defenseType, (LivingEntity)target, (double)withDamageBuffs);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPhysical(PhysicalDamageEvent event) {
        double scaledDamage = BuffListener.scaleDamage(event.getDamager(), event.getTarget(), event.getDamage(), null);
        if (scaledDamage <= 0.0) {
            event.setCancelled(true);
        } else {
            event.setDamage(scaledDamage);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSkill(SkillDamageEvent event) {
        double scaledDamage = BuffListener.scaleDamage(event.getDamager(), event.getTarget(), event.getDamage(), event.getClassification());
        if (scaledDamage <= 0.0) {
            event.setCancelled(true);
        } else {
            event.setDamage(scaledDamage);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onHeal(SkillHealEvent event) {
        double withBuff = BuffRegistry.scaleValue((String)BuffType.HEALING.getLocalizedName(), (LivingEntity)event.getTarget(), (double)event.getAmount());
        event.setAmount(withBuff);
        if (withBuff <= 0.0) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBuffExpire(BuffExpiredEvent event) {
        if (event.getKey().equals(BuffType.INVISIBILITY.getLocalizedName()) && PluginChecker.isProtocolLibActive()) {
            PacketListener.updateEquipment((Player)event.getEntity());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEffectExpire(EntityPotionEffectEvent event) {
        if (!(event.getEntity() instanceof Player) || !event.getModifiedType().equals(PotionEffectType.INVISIBILITY)) {
            return;
        }
        if (event.getAction().equals((Object)EntityPotionEffectEvent.Action.CLEARED) || event.getAction().equals((Object)EntityPotionEffectEvent.Action.REMOVED)) {
            BuffManager.getBuffData((LivingEntity)event.getEntity()).clearByType(BuffType.INVISIBILITY);
            if (PluginChecker.isProtocolLibActive()) {
                PacketListener.updateEquipment((Player)event.getEntity());
            }
        }
    }
}

