/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.player.PlayerSkill;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class CooldownMechanic
extends MechanicComponent {
    private static final String SKILL = "skill";
    private static final String TYPE = "type";
    private static final String VALUE = "value";

    @Override
    public String getKey() {
        return "cooldown";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (!(caster instanceof Player)) {
            return false;
        }
        String skill = this.settings.getString(SKILL, "");
        String type = this.settings.getString(TYPE, "all").toLowerCase();
        double value = this.parseValues(caster, VALUE, level, 0.0);
        PlayerData playerData = Fabled.getData((OfflinePlayer)((Player)caster));
        PlayerSkill skillData = playerData.getSkill(skill);
        if (skillData == null && !skill.equals("all")) {
            skillData = playerData.getSkill(this.skill.getName());
        }
        boolean worked = false;
        if (skill.equals("all")) {
            for (PlayerSkill data : playerData.getSkills()) {
                this.subtractCooldown(type, data, value);
                worked = true;
            }
        } else if (skillData != null) {
            this.subtractCooldown(type, skillData, value);
            worked = true;
        }
        return worked;
    }

    private void subtractCooldown(String type, PlayerSkill data, double value) {
        Bukkit.getScheduler().runTaskLater((Plugin)Fabled.inst(), () -> {
            if (type.equals("percent")) {
                data.subtractCooldown(value * (double)data.getCooldownLeft() / 100.0);
            } else {
                data.subtractCooldown(value);
            }
        }, 1L);
    }
}

