/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.condition;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Function;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.ItemChecker;
import studio.magemonkey.fabled.dynamic.condition.ConditionComponent;

public class ArmorCondition
extends ConditionComponent {
    private static final String ARMOR = "armor";
    private List<Function<EntityEquipment, ItemStack>> getters;

    @Override
    public String getKey() {
        return ARMOR;
    }

    @Override
    public void load(DynamicSkill skill, DataSection config) {
        super.load(skill, config);
        this.getters = this.determineGetters();
    }

    private List<Function<EntityEquipment, ItemStack>> determineGetters() {
        String type;
        switch (type = this.settings.getString(ARMOR).toLowerCase()) {
            case "helmet": {
                return ImmutableList.of(EntityEquipment::getHelmet);
            }
            case "chestplate": {
                return ImmutableList.of(EntityEquipment::getChestplate);
            }
            case "leggings": {
                return ImmutableList.of(EntityEquipment::getLeggings);
            }
            case "boots": {
                return ImmutableList.of(EntityEquipment::getBoots);
            }
        }
        return ImmutableList.of(EntityEquipment::getHelmet, EntityEquipment::getChestplate, EntityEquipment::getLeggings, EntityEquipment::getBoots);
    }

    @Override
    boolean test(LivingEntity caster, int level, LivingEntity target) {
        EntityEquipment equipment = target.getEquipment();
        return equipment != null && this.getters.stream().anyMatch(getter -> ItemChecker.check((ItemStack)getter.apply(equipment), level, this.settings));
    }
}

