/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.api.particle.EffectPlayer;
import studio.magemonkey.fabled.api.particle.ParticleHelper;
import studio.magemonkey.fabled.api.particle.ParticleSettings;
import studio.magemonkey.fabled.api.particle.target.FollowTarget;
import studio.magemonkey.fabled.api.projectile.CustomProjectile;
import studio.magemonkey.fabled.api.projectile.ItemProjectile;
import studio.magemonkey.fabled.api.projectile.ParticleProjectile;
import studio.magemonkey.fabled.api.projectile.ProjectileCallback;
import studio.magemonkey.fabled.api.util.ItemStackReader;
import studio.magemonkey.fabled.dynamic.TempEntity;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;
import studio.magemonkey.fabled.util.VectorUtil;

public class ItemProjectileMechanic
extends MechanicComponent
implements ProjectileCallback {
    private static final Vector UP = new Vector(0, 1, 0);
    private static final String ALLY = "group";
    private static final String WALLS = "walls";
    private static final String VELOCITY = "velocity";
    private static final String LIFESPAN = "lifespan";
    private static final String SPREAD = "spread";
    private static final String AMOUNT = "amount";
    private static final String ANGLE = "angle";
    private static final String HEIGHT = "height";
    private static final String RADIUS = "rain-radius";
    private static final String LEVEL = "skill_level";
    private static final String FORWARD = "forward";
    private static final String UPWARD = "upward";
    private static final String RIGHT = "right";
    private static final String DISTANCE = "distance";
    private static final String USE_EFFECT = "use-effect";
    private static final String EFFECT_KEY = "effect-key";

    @Override
    public String getKey() {
        return "item projectile";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        ItemStack item = ItemStackReader.read(this.settings);
        double speed = this.parseValues(caster, VELOCITY, level, 3.0);
        int amount = (int)this.parseValues(caster, AMOUNT, level, 1.0);
        String spread = this.settings.getString(SPREAD, "cone").toLowerCase();
        boolean ally = this.settings.getString(ALLY, "enemy").equalsIgnoreCase("ally");
        boolean walls = this.settings.getBool(WALLS, true);
        int lifespan = (int)(this.parseValues(caster, LIFESPAN, level, 9999.0) * 20.0);
        int distance = (int)this.parseValues(caster, DISTANCE, level, 50.0);
        Settings copy = new Settings(this.settings);
        copy.set(VELOCITY, this.parseValues(caster, VELOCITY, level, 1.0), 0.0);
        copy.set("particles", this.parseValues(caster, "particles", level, 1.0), 0.0);
        copy.set("radius", this.parseValues(caster, "radius", level, 0.0), 0.0);
        copy.set("homing-distance", this.parseValues(caster, "homing-distance", level, 20.0), 0.0);
        copy.set("correction", this.parseValues(caster, "correction", level, 0.2), 0.0);
        for (LivingEntity target : targets) {
            List<ItemProjectile> list;
            Location location = VectorUtil.getOffsetLocation(target, this.parseValues(caster, FORWARD, level, 0.0), this.parseValues(caster, RIGHT, level, 0.0), this.parseValues(caster, UPWARD, level, 0.0));
            if (spread.equals("rain")) {
                list = ItemProjectile.rain(caster, level, location, copy, item, this.parseValues(caster, RADIUS, level, 2.0), this.parseValues(caster, HEIGHT, level, 8.0), speed, amount, this, lifespan, distance, walls);
            } else {
                Vector dir = location.getDirection();
                if (spread.equals("horizontal cone")) {
                    dir.setY(0);
                    dir.normalize();
                }
                dir.multiply(speed);
                double angle = this.parseValues(caster, ANGLE, level, 30.0);
                list = ItemProjectile.spread(caster, level, dir, location, copy, item, angle, amount, this, lifespan, distance, walls);
            }
            for (ItemProjectile p : list) {
                Fabled.setMeta(p, LEVEL, level);
                p.setAllyEnemy(ally, !ally);
            }
            if (!this.settings.getBool(USE_EFFECT, false)) continue;
            EffectPlayer player = new EffectPlayer(this.settings);
            for (CustomProjectile customProjectile : list) {
                player.start(new FollowTarget(customProjectile), this.settings.getString(EFFECT_KEY, this.skill.getName()), 9999, level, true);
            }
        }
        return !targets.isEmpty();
    }

    @Override
    public void callback(CustomProjectile projectile, LivingEntity hit) {
        if (hit == null) {
            hit = new TempEntity(projectile.getLocation());
        }
        ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
        targets.add(hit);
        this.executeChildren(projectile.getShooter(), Fabled.getMetaInt(projectile, LEVEL), targets, this.skill.isForced(projectile.getShooter()));
        projectile.setCallback(null);
    }

    @Override
    public void playPreview(List<Runnable> onPreviewStop, final Player caster, final int level, final Supplier<List<LivingEntity>> targetSupplier) {
        final ArrayList targets = new ArrayList();
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                targets.clear();
                int amount = (int)ItemProjectileMechanic.this.parseValues((LivingEntity)caster, ItemProjectileMechanic.AMOUNT, level, 1.0);
                String spread = ItemProjectileMechanic.this.settings.getString(ItemProjectileMechanic.SPREAD, "cone").toLowerCase();
                boolean ally = ItemProjectileMechanic.this.settings.getString(ItemProjectileMechanic.ALLY, "enemy").equalsIgnoreCase("ally");
                int lifespan = (int)(ItemProjectileMechanic.this.parseValues((LivingEntity)caster, ItemProjectileMechanic.LIFESPAN, level, 9999.0) * 20.0);
                int distance = (int)ItemProjectileMechanic.this.parseValues((LivingEntity)caster, ItemProjectileMechanic.DISTANCE, level, 50.0);
                Settings copy = new Settings(ItemProjectileMechanic.this.settings);
                copy.set(ItemProjectileMechanic.VELOCITY, ItemProjectileMechanic.this.parseValues((LivingEntity)caster, ItemProjectileMechanic.VELOCITY, level, 1.0), 0.0);
                copy.set("particles", ItemProjectileMechanic.this.parseValues((LivingEntity)caster, "particles", level, 1.0), 0.0);
                copy.set("radius", ItemProjectileMechanic.this.parseValues((LivingEntity)caster, "radius", level, 0.0), 0.0);
                copy.set("collision-radius", 0.125, 0.0);
                copy.set("gravity", -0.04, 0.0);
                copy.set("drag", 0.02, 0.0);
                copy.set("period", ItemProjectileMechanic.this.preview.getInt("path-steps", 2));
                copy.set("homing-distance", ItemProjectileMechanic.this.parseValues((LivingEntity)caster, "homing-distance", level, 20.0), 0.0);
                copy.set("correction", ItemProjectileMechanic.this.parseValues((LivingEntity)caster, "correction", level, 0.2), 0.0);
                ProjectileCallback callback = (projectile, hit) -> {
                    if (hit == null) {
                        hit = new TempEntity(projectile.getLocation());
                    }
                    targets.add(hit);
                    if (ItemProjectileMechanic.this.preview.getBool("per-target")) {
                        ParticleHelper.play(hit.getLocation(), ItemProjectileMechanic.this.preview, Set.of(caster), "per-target-", ItemProjectileMechanic.this.preview.getBool("per-target-hitbox") ? hit.getBoundingBox() : null);
                    }
                };
                ArrayList<ParticleProjectile> list = new ArrayList<ParticleProjectile>();
                for (LivingEntity target : (List)targetSupplier.get()) {
                    Location location = VectorUtil.getOffsetLocation(target, ItemProjectileMechanic.this.parseValues((LivingEntity)caster, ItemProjectileMechanic.FORWARD, level, 0.0), ItemProjectileMechanic.this.parseValues((LivingEntity)caster, ItemProjectileMechanic.RIGHT, level, 0.0), ItemProjectileMechanic.this.parseValues((LivingEntity)caster, ItemProjectileMechanic.UPWARD, level, 0.0));
                    if (spread.equals("rain")) {
                        list.addAll(ParticleProjectile.rain((LivingEntity)caster, level, location, copy, ItemProjectileMechanic.this.parseValues((LivingEntity)caster, ItemProjectileMechanic.RADIUS, level, 2.0), ItemProjectileMechanic.this.parseValues((LivingEntity)caster, ItemProjectileMechanic.HEIGHT, level, 8.0), amount, callback, lifespan, distance));
                    } else {
                        Vector dir = location.getDirection();
                        if (spread.equals("horizontal cone")) {
                            dir.setY(0);
                            dir.normalize();
                        }
                        list.addAll(ParticleProjectile.spread((LivingEntity)caster, level, dir, location, copy, ItemProjectileMechanic.this.parseValues((LivingEntity)caster, ItemProjectileMechanic.ANGLE, level, 30.0), amount, callback, lifespan, distance));
                    }
                    for (ParticleProjectile p : list) {
                        Fabled.setMeta(p, ItemProjectileMechanic.LEVEL, level);
                        p.setAllyEnemy(ally, !ally);
                    }
                    Consumer<Location> onStep = ItemProjectileMechanic.this.preview.getBool("path") ? loc -> new ParticleSettings(ItemProjectileMechanic.this.preview, "path-").instance(caster, loc.getX(), loc.getY(), loc.getZ()) : loc -> {};
                    for (ParticleProjectile p : list) {
                        p.setOnStep(onStep);
                    }
                    for (ParticleProjectile p : list) {
                        while (p.isValid()) {
                            p.run();
                        }
                    }
                }
            }
        }.runTaskTimer((Plugin)Fabled.inst(), 0L, (long)Math.max(1, this.preview.getInt("period", 5)));
        onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        this.playChildrenPreviews(onPreviewStop, caster, level, () -> targets);
    }
}

