/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.codex.mccore.util.TextFormatter;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.api.event.DynamicTriggerEvent;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.skills.PassiveSkill;
import studio.magemonkey.fabled.api.skills.Skill;
import studio.magemonkey.fabled.api.skills.SkillShot;
import studio.magemonkey.fabled.dynamic.ComponentRegistry;
import studio.magemonkey.fabled.dynamic.EffectComponent;
import studio.magemonkey.fabled.dynamic.TriggerHandler;
import studio.magemonkey.fabled.dynamic.trigger.TriggerComponent;
import studio.magemonkey.fabled.log.Logger;

public class DynamicSkill
extends Skill
implements SkillShot,
PassiveSkill,
Listener {
    private static final Map<Integer, CastData> castData = new HashMap<Integer, CastData>();
    private final List<TriggerHandler> triggers = new ArrayList<TriggerHandler>();
    private final Map<String, EffectComponent> attribKeys = new HashMap<String, EffectComponent>();
    private final Map<Integer, Integer> active = new HashMap<Integer, Integer>();
    private final List<Integer> forced = new ArrayList<Integer>();
    private List<TriggerComponent> castTriggers = new ArrayList<TriggerComponent>();
    private List<TriggerComponent> initializeTriggers = new ArrayList<TriggerComponent>();
    private List<TriggerComponent> cleanupTriggers = new ArrayList<TriggerComponent>();
    private boolean cancel = false;
    private double multiplier = 1.0;
    private double bonus = 0.0;

    public DynamicSkill(String name) {
        super(name, "Dynamic", Material.JACK_O_LANTERN, 1);
    }

    public static CastData getCastData(LivingEntity caster) {
        if (caster == null) {
            return null;
        }
        CastData entCastData = castData.get(caster.getEntityId());
        if (entCastData == null) {
            entCastData = new CastData(caster);
            castData.put(caster.getEntityId(), entCastData);
        }
        return entCastData;
    }

    public static void clearCastData(LivingEntity entity) {
        castData.remove(entity.getEntityId());
    }

    @Override
    public boolean canCast() {
        return this.castTriggers != null && !this.castTriggers.isEmpty();
    }

    public boolean isActive(LivingEntity caster) {
        return this.active.containsKey(caster.getEntityId());
    }

    public int getActiveLevel(LivingEntity caster) {
        return this.active.containsKey(caster.getEntityId()) ? this.active.get(caster.getEntityId()) : 0;
    }

    void setAttribKey(String key, EffectComponent component) {
        this.attribKeys.put(key, component);
    }

    public void cancelTrigger() {
        this.cancel = true;
    }

    void applyCancelled(Cancellable event) {
        if (this.checkCancelled()) {
            event.setCancelled(true);
        }
    }

    public boolean checkCancelled() {
        boolean result = this.cancel;
        this.cancel = false;
        return result;
    }

    public void setImmediateBuff(double value, boolean flat) {
        if (flat) {
            this.bonus = value;
        } else {
            this.multiplier = value;
        }
    }

    public double applyImmediateBuff(double damage) {
        double result = damage * this.multiplier + this.bonus;
        this.multiplier = 1.0;
        this.bonus = 0.0;
        return result;
    }

    public void registerEvents(Fabled plugin) {
        for (TriggerHandler triggerHandler : this.triggers) {
            triggerHandler.register(plugin);
        }
    }

    @Override
    public void update(LivingEntity user, int prevLevel, int newLevel) {
        this.active.put(user.getEntityId(), newLevel);
        for (TriggerHandler triggerHandler : this.triggers) {
            triggerHandler.init(user, newLevel);
        }
    }

    @Override
    public void initialize(LivingEntity user, int level) {
        for (TriggerComponent initializeTrigger : this.initializeTriggers) {
            this.trigger(user, user, level, initializeTrigger);
        }
        Bukkit.getPluginManager().callEvent((Event)new DynamicTriggerEvent(user, this, null, "initialize"));
        this.active.put(user.getEntityId(), level);
        for (TriggerHandler triggerHandler : this.triggers) {
            triggerHandler.init(user, level);
        }
    }

    @Override
    public void stopEffects(LivingEntity user) {
        this.active.remove(user.getEntityId());
        if (this.forced.contains(user.getEntityId())) {
            this.forced.remove((Object)user.getEntityId());
        }
        for (TriggerHandler triggerHandler : this.triggers) {
            triggerHandler.cleanup(user);
        }
        this.cleanup(user, this.castTriggers);
        this.cleanup(user, this.initializeTriggers);
        for (TriggerComponent cleanupTrigger : this.cleanupTriggers) {
            this.trigger(user, user, 1, cleanupTrigger);
        }
        Bukkit.getPluginManager().callEvent((Event)new DynamicTriggerEvent(user, this, null, "cleanup"));
    }

    private void cleanup(LivingEntity user, List<TriggerComponent> components) {
        if (components == null) {
            return;
        }
        components.forEach(component -> this.cleanup(user, (TriggerComponent)component));
    }

    private void cleanup(LivingEntity user, TriggerComponent component) {
        if (component != null) {
            component.cleanUp(user);
        }
    }

    public boolean isForced(LivingEntity user) {
        return this.forced.contains(user.getEntityId());
    }

    @Override
    public boolean cast(LivingEntity user, int level, boolean force) {
        if (!force && !Fabled.getSettings().isWorldEnabled(user.getWorld())) {
            return false;
        }
        if (force && !this.isForced(user)) {
            this.forced.add(user.getEntityId());
        }
        boolean cast = false;
        for (TriggerComponent castTrigger : this.castTriggers) {
            boolean result = this.trigger(user, user, level, castTrigger, force);
            cast = cast || result;
        }
        if (!cast) {
            return false;
        }
        Bukkit.getPluginManager().callEvent((Event)new DynamicTriggerEvent(user, this, null, "cast"));
        return true;
    }

    @Override
    public boolean cast(LivingEntity user, int level) {
        return this.cast(user, level, false);
    }

    @Override
    public void playPreview(PlayerData playerData, int level) {
        if (this.castTriggers == null || this.castTriggers.isEmpty()) {
            return;
        }
        ArrayList<Runnable> onPreviewStop = new ArrayList<Runnable>();
        for (TriggerComponent castTrigger : this.castTriggers) {
            castTrigger.playChildrenPreviews(onPreviewStop, playerData.getPlayer(), level, () -> ImmutableList.of((Object)playerData.getPlayer()));
        }
        playerData.setOnPreviewStop(() -> onPreviewStop.forEach(Runnable::run));
    }

    @Override
    protected String getAttrName(String key) {
        if (key.contains(".")) {
            return TextFormatter.format((String)key.substring(key.lastIndexOf(46) + 1));
        }
        return super.getAttrName(key);
    }

    @Override
    protected Object getAttr(LivingEntity caster, String key, int level) {
        if (key.contains(".")) {
            String[] path = key.split("\\.");
            String attr = path[1].toLowerCase();
            if (this.attribKeys.containsKey(path[0]) && this.attribKeys.get((Object)path[0]).settings.has(attr)) {
                return this.format(this.attribKeys.get(path[0]).parseValues(caster, attr, level, 0.0));
            }
            return 0;
        }
        return super.getAttr(caster, key, level);
    }

    private boolean trigger(LivingEntity user, LivingEntity target, int level, TriggerComponent component) {
        return this.trigger(user, target, level, component, false);
    }

    private boolean trigger(LivingEntity user, LivingEntity target, int level, TriggerComponent component, boolean force) {
        return component != null && component.trigger(user, target, level, force);
    }

    @Override
    public void load(DataSection config) {
        super.load(config);
        DataSection triggers = config.getSection("components");
        if (triggers == null) {
            return;
        }
        this.castTriggers.clear();
        this.initializeTriggers.clear();
        this.cleanupTriggers.clear();
        for (String key : triggers.keys()) {
            String modified = key.replaceAll("-.+", "");
            try {
                DataSection settings = triggers.getSection(key);
                if (modified.equalsIgnoreCase("CAST")) {
                    this.castTriggers.add(this.loadComponent(settings));
                    continue;
                }
                if (modified.equalsIgnoreCase("INITIALIZE")) {
                    this.initializeTriggers.add(this.loadComponent(settings));
                    continue;
                }
                if (modified.equalsIgnoreCase("CLEANUP")) {
                    this.cleanupTriggers.add(this.loadComponent(settings));
                    continue;
                }
                this.triggers.add(new TriggerHandler(this, key, ComponentRegistry.getTrigger(modified), this.loadComponent(settings)));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Logger.invalid("Invalid trigger for the skill \"" + this.getName() + "\" - \"" + key + "\"");
            }
        }
    }

    private TriggerComponent loadComponent(DataSection data) {
        TriggerComponent component = new TriggerComponent();
        component.load(this, data);
        return component;
    }

    @Override
    public void save(DataSection config) {
        int i;
        super.save(config);
        DataSection triggers = config.createSection("components");
        for (TriggerHandler triggerHandler : this.triggers) {
            triggerHandler.getComponent().save(triggers.createSection(TextFormatter.format((String)triggerHandler.getKey())));
        }
        for (i = 0; i < this.castTriggers.size(); ++i) {
            TriggerComponent castTrigger = this.castTriggers.get(i);
            this.save(triggers, castTrigger, "Cast-" + i);
        }
        for (i = 0; i < this.initializeTriggers.size(); ++i) {
            TriggerComponent initializeTrigger = this.initializeTriggers.get(i);
            this.save(triggers, initializeTrigger, "Initialize-" + i);
        }
        for (i = 0; i < this.cleanupTriggers.size(); ++i) {
            TriggerComponent cleanupTrigger = this.cleanupTriggers.get(i);
            this.save(triggers, cleanupTrigger, "Cleanup-" + i);
        }
    }

    private void save(DataSection triggers, TriggerComponent component, String key) {
        if (component != null) {
            component.save(triggers.createSection(TextFormatter.format((String)key)));
        }
    }
}

