/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cmd;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.mccore.commands.CommandManager;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.skills.SkillShot;

public class CmdCast
implements IFunction,
TabCompleter {
    private static final String NOT_SKILL = "not-skill";
    private static final String NOT_AVAILABLE = "not-available";
    private static final String NOT_UNLOCKED = "not-unlocked";
    private static final String NOT_PLAYER = "not-player";
    private static final String DISABLED = "world-disabled";

    public void execute(ConfigurableCommand command, Plugin plugin, CommandSender sender, String[] args, boolean silent) {
        if (!(sender instanceof Player)) {
            command.sendMessage(sender, NOT_PLAYER, "&4Only players can use this command", silent, new CustomFilter[0]);
        } else if (!Fabled.getSettings().isWorldEnabled(((Player)sender).getWorld())) {
            command.sendMessage(sender, DISABLED, "&4You cannot use this command in this world", silent, new CustomFilter[0]);
        } else if (args.length >= 1) {
            PlayerData player = Fabled.getData((OfflinePlayer)((Player)sender));
            String skill = String.join((CharSequence)" ", args);
            if (!Fabled.isSkillRegistered(skill)) {
                command.sendMessage(sender, NOT_SKILL, String.valueOf(ChatColor.RED) + "That is not a valid skill name", silent, new CustomFilter[0]);
            } else if (!player.hasSkill(skill)) {
                command.sendMessage(sender, NOT_AVAILABLE, String.valueOf(ChatColor.RED) + "That skill is not available for your class", silent, new CustomFilter[0]);
            } else if (!player.hasSkill(skill) || player.getSkillLevel(skill) == 0) {
                command.sendMessage(sender, NOT_UNLOCKED, String.valueOf(ChatColor.RED) + "You must level up the skill first", silent, new CustomFilter[0]);
            } else {
                player.cast(skill);
            }
        } else {
            CommandManager.displayUsage((ConfigurableCommand)command, (CommandSender)sender, (int)1);
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!(commandSender instanceof Player)) {
            return null;
        }
        return ConfigurableCommand.getTabCompletions((Collection)Fabled.getData((OfflinePlayer)((Player)commandSender)).getSkills().stream().filter(playerSkill -> playerSkill.getData() instanceof SkillShot).map(playerSkill -> playerSkill.getData().getKey()).collect(Collectors.toList()), (String[])args);
    }
}

