/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.trigger;

import java.util.List;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.dynamic.trigger.Trigger;

public class WorldChangeTrigger
implements Trigger<PlayerChangedWorldEvent> {
    @Override
    public String getKey() {
        return "WORLD_CHANGE";
    }

    @Override
    public Class<PlayerChangedWorldEvent> getEvent() {
        return PlayerChangedWorldEvent.class;
    }

    @Override
    public boolean shouldTrigger(PlayerChangedWorldEvent event, int level, Settings settings) {
        World from = event.getFrom();
        World to = event.getPlayer().getWorld();
        List<String> worlds = settings.getStringList("worlds");
        boolean inverted = settings.getBool("inverted", false);
        String direction = settings.getString("direction", "to");
        boolean correctWorld = false;
        if (direction.equalsIgnoreCase("to")) {
            correctWorld = worlds.contains("Any") || worlds.contains(to.getName());
        } else if (direction.equalsIgnoreCase("from")) {
            correctWorld = worlds.contains("Any") || worlds.contains(from.getName());
        } else if (direction.equalsIgnoreCase("both")) {
            correctWorld = worlds.contains("Any") || worlds.contains(to.getName()) || worlds.contains(from.getName());
        }
        return correctWorld != inverted;
    }

    @Override
    public void setValues(PlayerChangedWorldEvent event, CastData data) {
    }

    @Override
    public LivingEntity getCaster(PlayerChangedWorldEvent event) {
        return event.getPlayer();
    }

    @Override
    public LivingEntity getTarget(PlayerChangedWorldEvent event, Settings settings) {
        return event.getPlayer();
    }
}

