/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.enums.ExpSource;
import studio.magemonkey.fabled.api.player.PlayerClass;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;
import studio.magemonkey.fabled.listener.MechanicListener;

public class ExperienceMechanic
extends MechanicComponent {
    private static final String VALUE = "value";
    private static final String MODE = "mode";
    private static final String TYPE = "type";
    private static final String GROUP = "group";
    private static final String LEVEL_DOWN = "level-down";
    private static final String VANILLA = "vanilla";

    @Override
    public String getKey() {
        return "experience";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (!(caster instanceof Player)) {
            return false;
        }
        Player player = (Player)caster;
        boolean vanilla = this.settings.getBool(VANILLA, false);
        if (vanilla) {
            return this.vanillaExperienceMechanic(player, level, targets, force);
        }
        return this.classExperienceMechanic(player, level, targets, force);
    }

    public boolean vanillaExperienceMechanic(Player caster, int level, List<LivingEntity> targets, boolean force) {
        int expValue = (int)this.getNum((LivingEntity)caster, VALUE, 0.0);
        String mode = this.settings.getString(MODE, "give").toLowerCase();
        String type = this.settings.getString(TYPE, "flat").toLowerCase();
        boolean levelDown = this.settings.getBool(LEVEL_DOWN, true);
        int previousLevel = caster.getLevel();
        if (type.equals("levels")) {
            switch (mode) {
                case "give": {
                    caster.giveExpLevels(expValue);
                    break;
                }
                case "set": {
                    caster.setLevel(expValue);
                    break;
                }
                case "take": {
                    caster.giveExpLevels(-expValue);
                    break;
                }
                default: {
                    return false;
                }
            }
        } else if (type.equals("percent")) {
            int expToLevel = caster.getExpToLevel();
            int percentExp = expToLevel * expValue / 100;
            switch (mode) {
                case "give": {
                    caster.giveExp(percentExp);
                    break;
                }
                case "set": {
                    caster.setExp((float)expValue / 100.0f);
                    break;
                }
                case "take": {
                    caster.giveExp(-percentExp);
                    break;
                }
                default: {
                    return false;
                }
            }
        } else if (type.equals("flat")) {
            switch (mode) {
                case "give": {
                    caster.giveExp(expValue);
                    break;
                }
                case "set": {
                    caster.setLevel(0);
                    caster.setExp(0.0f);
                    caster.giveExp(expValue);
                    break;
                }
                case "take": {
                    caster.giveExp(-expValue);
                    break;
                }
                default: {
                    return false;
                }
            }
        } else {
            return false;
        }
        if (caster.getLevel() < previousLevel && !levelDown) {
            caster.setLevel(previousLevel);
            caster.setExp(0.0f);
        }
        return true;
    }

    public boolean classExperienceMechanic(Player caster, int level, List<LivingEntity> targets, boolean force) {
        int value = (int)this.getNum((LivingEntity)caster, VALUE, 0.0);
        String mode = this.settings.getString(MODE, "give").toLowerCase();
        String type = this.settings.getString(TYPE, "flat").toLowerCase();
        boolean levelDown = this.settings.getBool(LEVEL_DOWN, true);
        String group = this.settings.getString(GROUP, "class");
        if (Fabled.getGroups().stream().noneMatch(c -> c.equalsIgnoreCase(group))) {
            return false;
        }
        PlayerClass playerClass = Fabled.getData((OfflinePlayer)caster).getClass(group);
        double allNextLevelExp = playerClass.getData().getRequiredExp(playerClass.getLevel());
        if (type.equals("levels")) {
            switch (mode) {
                case "give": {
                    playerClass.giveLevels(value);
                    break;
                }
                case "set": {
                    playerClass.setLevel(value);
                    break;
                }
                case "take": {
                    playerClass.loseLevels(value);
                    break;
                }
                default: {
                    return false;
                }
            }
        } else if (type.equals("percent")) {
            double percentExp = allNextLevelExp * (double)value / 100.0;
            switch (mode) {
                case "give": {
                    MechanicListener.addExemptExperience(caster, percentExp);
                    playerClass.giveExp(percentExp, ExpSource.PLUGIN);
                    break;
                }
                case "set": {
                    playerClass.setExp(percentExp);
                    break;
                }
                case "take": {
                    playerClass.loseExp(percentExp, false, levelDown, true);
                    break;
                }
                default: {
                    return false;
                }
            }
        } else if (type.equals("flat")) {
            switch (mode) {
                case "give": {
                    MechanicListener.addExemptExperience(caster, value);
                    playerClass.giveExp(value, ExpSource.PLUGIN);
                    break;
                }
                case "set": {
                    playerClass.setExp(value);
                    break;
                }
                case "take": {
                    playerClass.loseExp(value, false, levelDown, true);
                    break;
                }
                default: {
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }
}

