/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.enums.Operation;
import studio.magemonkey.fabled.api.player.PlayerAttributeModifier;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class AttributeMechanic
extends MechanicComponent {
    private static final String KEY = "key";
    private static final String OPERATION = "operation";
    private static final String AMOUNT = "amount";
    private static final String SECONDS = "seconds";
    private static final String STACKABLE = "stackable";
    private final Map<Integer, Map<String, AttribTask>> tasks = new HashMap<Integer, Map<String, AttribTask>>();

    @Override
    public String getKey() {
        return "attribute";
    }

    @Override
    protected void doCleanUp(LivingEntity user) {
        Map<String, AttribTask> casterTasks = this.tasks.remove(user.getEntityId());
        if (casterTasks != null) {
            casterTasks.values().forEach(AttribTask::stop);
        }
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        String data;
        if (targets.isEmpty()) {
            return false;
        }
        List<Object> keys = !this.settings.getStringList(KEY).isEmpty() ? this.settings.getStringList(KEY).stream().filter(key -> Fabled.getAttributesManager().getAttribute((String)key) != null).collect(Collectors.toList()) : ((data = this.settings.getString(KEY)) == null || data.isBlank() || data.equals("[]") ? new ArrayList() : List.of(this.settings.getString(KEY).split(",")));
        Map casterTasks = this.tasks.computeIfAbsent(caster.getEntityId(), HashMap::new);
        double amount = this.parseValues(caster, AMOUNT, level, 5.0);
        double seconds = this.parseValues(caster, SECONDS, level, 3.0);
        boolean stackable = this.settings.getString(STACKABLE, "false").equalsIgnoreCase("true");
        int ticks = (int)(seconds * 20.0);
        String operation = this.settings.getString(OPERATION, "ADD_NUMBER");
        boolean worked = false;
        for (LivingEntity target : targets) {
            if (!(target instanceof Player)) continue;
            worked = true;
            PlayerData data2 = Fabled.getData((OfflinePlayer)((Player)target));
            PlayerAttributeModifier modifier = new PlayerAttributeModifier("fabled.mechanic.attribute_mechanic", amount, Operation.valueOf(operation), false);
            if (casterTasks.containsKey(data2.getPlayerName()) && !stackable) {
                Object old = (AttribTask)((Object)casterTasks.remove(data2.getPlayerName()));
                data2.removeAttributeModifier(((AttribTask)((Object)old)).modifier.getUUID(), false);
                old.cancel();
            }
            for (String string : keys) {
                data2.addAttributeModifier(string, modifier, true);
            }
            AttribTask task = new AttribTask(caster.getEntityId(), data2, modifier);
            casterTasks.put(data2.getPlayerName(), task);
            if (ticks < 0) continue;
            Fabled.schedule(task, ticks);
        }
        return worked;
    }

    private class AttribTask
    extends BukkitRunnable {
        private final PlayerData data;
        private final PlayerAttributeModifier modifier;
        private final int id;
        private boolean running = false;
        private boolean stopped = false;

        AttribTask(int id, PlayerData data, PlayerAttributeModifier modifier) {
            this.id = id;
            this.data = data;
            this.modifier = modifier;
        }

        public void stop() {
            if (!this.stopped) {
                this.stopped = true;
                this.run();
                if (this.running) {
                    this.cancel();
                }
            }
        }

        public BukkitTask runTaskLater(Plugin plugin, long delay) {
            this.running = true;
            return super.runTaskLater(plugin, delay);
        }

        public void run() {
            this.data.removeAttributeModifier(this.modifier.getUUID(), true);
            if (AttributeMechanic.this.tasks.containsKey(this.id)) {
                AttributeMechanic.this.tasks.get(this.id).remove(this.data.getPlayerName());
            }
            this.running = false;
        }
    }
}

