/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.event.Event;
import org.bukkit.plugin.EventExecutor;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.dynamic.ComponentType;
import studio.magemonkey.fabled.dynamic.EffectComponent;
import studio.magemonkey.fabled.dynamic.TriggerHandler;
import studio.magemonkey.fabled.dynamic.condition.ActionBarCondition;
import studio.magemonkey.fabled.dynamic.condition.AirCondition;
import studio.magemonkey.fabled.dynamic.condition.AltitudeCondition;
import studio.magemonkey.fabled.dynamic.condition.ArmorCondition;
import studio.magemonkey.fabled.dynamic.condition.AttackIndicatorCondition;
import studio.magemonkey.fabled.dynamic.condition.AttributeCondition;
import studio.magemonkey.fabled.dynamic.condition.BiomeCondition;
import studio.magemonkey.fabled.dynamic.condition.BlockCondition;
import studio.magemonkey.fabled.dynamic.condition.BlockingCondition;
import studio.magemonkey.fabled.dynamic.condition.BurningCondition;
import studio.magemonkey.fabled.dynamic.condition.CastLevelCondition;
import studio.magemonkey.fabled.dynamic.condition.CeilingCondition;
import studio.magemonkey.fabled.dynamic.condition.ChanceCondition;
import studio.magemonkey.fabled.dynamic.condition.ClassCondition;
import studio.magemonkey.fabled.dynamic.condition.ClassLevelCondition;
import studio.magemonkey.fabled.dynamic.condition.ColorCondition;
import studio.magemonkey.fabled.dynamic.condition.CombatCondition;
import studio.magemonkey.fabled.dynamic.condition.CrouchCondition;
import studio.magemonkey.fabled.dynamic.condition.DirectionCondition;
import studio.magemonkey.fabled.dynamic.condition.DistanceCondition;
import studio.magemonkey.fabled.dynamic.condition.ElevationCondition;
import studio.magemonkey.fabled.dynamic.condition.ElseCondition;
import studio.magemonkey.fabled.dynamic.condition.EntityTypeCondition;
import studio.magemonkey.fabled.dynamic.condition.FireCondition;
import studio.magemonkey.fabled.dynamic.condition.FlagCondition;
import studio.magemonkey.fabled.dynamic.condition.FoodCondition;
import studio.magemonkey.fabled.dynamic.condition.GlideCondition;
import studio.magemonkey.fabled.dynamic.condition.GroundCondition;
import studio.magemonkey.fabled.dynamic.condition.HealthCondition;
import studio.magemonkey.fabled.dynamic.condition.InventoryCondition;
import studio.magemonkey.fabled.dynamic.condition.ItemCondition;
import studio.magemonkey.fabled.dynamic.condition.LightCondition;
import studio.magemonkey.fabled.dynamic.condition.LoreCondition;
import studio.magemonkey.fabled.dynamic.condition.ManaCondition;
import studio.magemonkey.fabled.dynamic.condition.MoneyCondition;
import studio.magemonkey.fabled.dynamic.condition.MoonCondition;
import studio.magemonkey.fabled.dynamic.condition.MountedCondition;
import studio.magemonkey.fabled.dynamic.condition.MountingCondition;
import studio.magemonkey.fabled.dynamic.condition.MythicMobTypeCondition;
import studio.magemonkey.fabled.dynamic.condition.NameCondition;
import studio.magemonkey.fabled.dynamic.condition.OffhandCondition;
import studio.magemonkey.fabled.dynamic.condition.PermissionCondition;
import studio.magemonkey.fabled.dynamic.condition.PotionCondition;
import studio.magemonkey.fabled.dynamic.condition.SkillLevelCondition;
import studio.magemonkey.fabled.dynamic.condition.SlotCondition;
import studio.magemonkey.fabled.dynamic.condition.SprintCondition;
import studio.magemonkey.fabled.dynamic.condition.StatusCondition;
import studio.magemonkey.fabled.dynamic.condition.TimeCondition;
import studio.magemonkey.fabled.dynamic.condition.ToolCondition;
import studio.magemonkey.fabled.dynamic.condition.ValueCondition;
import studio.magemonkey.fabled.dynamic.condition.ValueTextCondition;
import studio.magemonkey.fabled.dynamic.condition.WaterCondition;
import studio.magemonkey.fabled.dynamic.condition.WeatherCondition;
import studio.magemonkey.fabled.dynamic.condition.WorldCondition;
import studio.magemonkey.fabled.dynamic.condition.YawCondition;
import studio.magemonkey.fabled.dynamic.custom.CustomComponent;
import studio.magemonkey.fabled.dynamic.custom.CustomEffectComponent;
import studio.magemonkey.fabled.dynamic.custom.EditorOption;
import studio.magemonkey.fabled.dynamic.mechanic.AbortSkillMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.AirModifyMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.AirSetMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.ArmorMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.AttributeMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.BlockMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.BuffMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.CancelEffectMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.CancelMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.ChannelMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.CleanseMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.CommandMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.CooldownMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.DamageBuffMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.DamageLoreMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.DamageMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.DefenseBuffMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.DelayMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.DisguiseMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.DurabilityMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.ExperienceMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.ExplosionMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.FireMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.FlagClearMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.FlagMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.FlagToggleMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.FlyMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.FoodMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.ForgetTargetsMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.HealMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.HealthSetMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.HeldItemMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.ImmunityMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.InterruptMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.InvisibilityMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.ItemDropMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.ItemMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.ItemProjectileMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.ItemRemoveMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.LaunchMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.LightningMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.ManaMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.MessageMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.MineMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.MoneyMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.MountMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.MythicMobSkill;
import studio.magemonkey.fabled.dynamic.mechanic.PassiveMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.PermissionMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.PotionMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.PotionProjectileMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.ProjectileMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.PurgeMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.PushMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.RememberTargetsMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.RepeatMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.ShieldMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.SignalEmitMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.SkillCastMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.SoundMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.StatMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.StatusMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.SummonMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.TauntMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.ThrowMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.TriggerMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.WolfMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.armorstand.ArmorStandMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.armorstand.ArmorStandPoseMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.armorstand.ArmorStandRemoveMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.particle.ParticleAnimationMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.particle.ParticleEffectMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.particle.ParticleImageMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.particle.ParticleMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.particle.ParticleProjectileMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.value.ValueAddMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.value.ValueAttributeMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.value.ValueCopyMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.value.ValueDistanceMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.value.ValueDivideMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.value.ValueHealthMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.value.ValueLoadMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.value.ValueLocationMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.value.ValueLoreMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.value.ValueLoreSlotMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.value.ValueManaMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.value.ValueMathMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.value.ValueMultiplyMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.value.ValuePlaceholderMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.value.ValueRandomMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.value.ValueRotationMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.value.ValueRoundMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.value.ValueSetMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.warp.WarpLocMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.warp.WarpMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.warp.WarpRandomMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.warp.WarpSwapMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.warp.WarpTargetMechanic;
import studio.magemonkey.fabled.dynamic.mechanic.warp.WarpValueMechanic;
import studio.magemonkey.fabled.dynamic.target.AreaTarget;
import studio.magemonkey.fabled.dynamic.target.ConeTarget;
import studio.magemonkey.fabled.dynamic.target.LinearTarget;
import studio.magemonkey.fabled.dynamic.target.LocationTarget;
import studio.magemonkey.fabled.dynamic.target.NearestTarget;
import studio.magemonkey.fabled.dynamic.target.OffsetTarget;
import studio.magemonkey.fabled.dynamic.target.RememberTarget;
import studio.magemonkey.fabled.dynamic.target.SelfTarget;
import studio.magemonkey.fabled.dynamic.target.SingleTarget;
import studio.magemonkey.fabled.dynamic.trigger.AirTrigger;
import studio.magemonkey.fabled.dynamic.trigger.ArmorEquipTrigger;
import studio.magemonkey.fabled.dynamic.trigger.AttributeChangeTrigger;
import studio.magemonkey.fabled.dynamic.trigger.BlockBreakTrigger;
import studio.magemonkey.fabled.dynamic.trigger.BlockPlaceTrigger;
import studio.magemonkey.fabled.dynamic.trigger.ChatTrigger;
import studio.magemonkey.fabled.dynamic.trigger.ClickLeftTrigger;
import studio.magemonkey.fabled.dynamic.trigger.ClickRightTrigger;
import studio.magemonkey.fabled.dynamic.trigger.ConsumeTrigger;
import studio.magemonkey.fabled.dynamic.trigger.CrouchTrigger;
import studio.magemonkey.fabled.dynamic.trigger.DeathTrigger;
import studio.magemonkey.fabled.dynamic.trigger.DropItemTrigger;
import studio.magemonkey.fabled.dynamic.trigger.EntityResurrectTrigger;
import studio.magemonkey.fabled.dynamic.trigger.EntityTargetTrigger;
import studio.magemonkey.fabled.dynamic.trigger.EnvironmentalTrigger;
import studio.magemonkey.fabled.dynamic.trigger.ExperienceTrigger;
import studio.magemonkey.fabled.dynamic.trigger.FishingBiteTrigger;
import studio.magemonkey.fabled.dynamic.trigger.FishingFailTrigger;
import studio.magemonkey.fabled.dynamic.trigger.FishingFishTrigger;
import studio.magemonkey.fabled.dynamic.trigger.FishingGrabTrigger;
import studio.magemonkey.fabled.dynamic.trigger.FishingGroundTrigger;
import studio.magemonkey.fabled.dynamic.trigger.FishingReelTrigger;
import studio.magemonkey.fabled.dynamic.trigger.FlagExpireTrigger;
import studio.magemonkey.fabled.dynamic.trigger.FlagTrigger;
import studio.magemonkey.fabled.dynamic.trigger.FlightToggleTrigger;
import studio.magemonkey.fabled.dynamic.trigger.GlideTrigger;
import studio.magemonkey.fabled.dynamic.trigger.HarvestTrigger;
import studio.magemonkey.fabled.dynamic.trigger.HealTrigger;
import studio.magemonkey.fabled.dynamic.trigger.ItemSwapTrigger;
import studio.magemonkey.fabled.dynamic.trigger.JumpTrigger;
import studio.magemonkey.fabled.dynamic.trigger.KillTrigger;
import studio.magemonkey.fabled.dynamic.trigger.LandTrigger;
import studio.magemonkey.fabled.dynamic.trigger.LaunchTrigger;
import studio.magemonkey.fabled.dynamic.trigger.MoveTrigger;
import studio.magemonkey.fabled.dynamic.trigger.PhysicalDealtTrigger;
import studio.magemonkey.fabled.dynamic.trigger.PhysicalTakenTrigger;
import studio.magemonkey.fabled.dynamic.trigger.ProjectileHitTrigger;
import studio.magemonkey.fabled.dynamic.trigger.ProjectileTickTrigger;
import studio.magemonkey.fabled.dynamic.trigger.RiptideTrigger;
import studio.magemonkey.fabled.dynamic.trigger.ShearTrigger;
import studio.magemonkey.fabled.dynamic.trigger.ShieldTrigger;
import studio.magemonkey.fabled.dynamic.trigger.SignalTrigger;
import studio.magemonkey.fabled.dynamic.trigger.SkillCastTrigger;
import studio.magemonkey.fabled.dynamic.trigger.SkillDealtTrigger;
import studio.magemonkey.fabled.dynamic.trigger.SkillTakenTrigger;
import studio.magemonkey.fabled.dynamic.trigger.SkillUpgradeTrigger;
import studio.magemonkey.fabled.dynamic.trigger.SprintTrigger;
import studio.magemonkey.fabled.dynamic.trigger.StripLogTrigger;
import studio.magemonkey.fabled.dynamic.trigger.Trigger;
import studio.magemonkey.fabled.dynamic.trigger.WorldChangeTrigger;

public class ComponentRegistry {
    static final Map<ComponentType, Map<String, Class<?>>> COMPONENTS = new EnumMap(ComponentType.class);
    static final Map<String, Trigger<?>> TRIGGERS = new HashMap();
    private static final Map<Trigger<?>, EventExecutor> EXECUTORS = new HashMap();

    public static Map<ComponentType, Map<String, Class<?>>> getComponents() {
        return Collections.unmodifiableMap(COMPONENTS);
    }

    public static Map<String, Trigger<?>> getTriggers() {
        return Collections.unmodifiableMap(TRIGGERS);
    }

    public static Map<Trigger<?>, EventExecutor> getExecutors() {
        return Collections.unmodifiableMap(EXECUTORS);
    }

    public static Trigger<?> getTrigger(String key) {
        return TRIGGERS.get(key.toUpperCase(Locale.US).replace(' ', '_'));
    }

    static EffectComponent getComponent(ComponentType type, String key) {
        Class<?> componentClass = COMPONENTS.get((Object)type).get(key.toLowerCase());
        if (componentClass == null) {
            throw new IllegalArgumentException("Invalid component key - " + key);
        }
        try {
            return (EffectComponent)componentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid component - does not have a default constructor");
        }
    }

    static EventExecutor getExecutor(Trigger<?> trigger) {
        return EXECUTORS.get(trigger);
    }

    public static <T extends Event> void register(Trigger<T> trigger) {
        String key = trigger.getKey().toUpperCase(Locale.US).replace(' ', '_');
        if (ComponentRegistry.getTrigger(key) != null) {
            throw new IllegalArgumentException("Trigger with key " + key + " already exists");
        }
        if (key.contains("-")) {
            throw new IllegalArgumentException(key + " is not a valid key: must not contain dashes");
        }
        TRIGGERS.put(key, trigger);
        EXECUTORS.put(trigger, (listener, event) -> {
            if (!trigger.getEvent().isInstance(event)) {
                return;
            }
            ((TriggerHandler)listener).apply(event, trigger);
        });
    }

    public static void register(CustomEffectComponent component) {
        ComponentRegistry.register((EffectComponent)component);
    }

    public static void save() {
        StringBuilder builder = new StringBuilder("[");
        TRIGGERS.values().forEach(trigger -> ComponentRegistry.append(trigger, builder));
        COMPONENTS.forEach((type, map) -> map.keySet().forEach(key -> ComponentRegistry.append(ComponentRegistry.getComponent(type, key), builder)));
        if (builder.length() > 2) {
            builder.replace(builder.length() - 1, builder.length(), "]");
        } else {
            builder.append(']');
        }
        File file = new File(Fabled.inst().getDataFolder(), "tool-config.json");
        try (FileOutputStream out = new FileOutputStream(file);){
            BufferedWriter write = new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
            write.write(builder.toString());
            write.close();
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
    }

    private static void append(Object obj, StringBuilder builder) {
        if (!(obj instanceof CustomComponent)) {
            return;
        }
        CustomComponent component = (CustomComponent)obj;
        builder.append("{\"type\":\"").append(component.getType().name()).append("\",\"key\":\"").append(component.getKey()).append("\",\"display\":\"").append(component.getDisplayName()).append("\",\"container\":\"").append(component.isContainer()).append("\",\"description\":\"").append(component.getDescription()).append("\",\"options\":[");
        boolean first = true;
        for (EditorOption option : component.getOptions()) {
            if (!first) {
                builder.append(',');
            }
            first = false;
            builder.append("{\"type\":\"").append((Object)option.type).append("\",\"key\":\"").append(option.key).append("\",\"display\":\"").append(option.name).append("\",\"description\":\"").append(option.description).append("\"");
            option.extra.forEach((key, value) -> builder.append(",\"").append((String)key).append("\":").append((String)value));
            builder.append("}");
        }
        builder.append("]},");
    }

    public static void register(EffectComponent component) {
        COMPONENTS.computeIfAbsent(component.getType(), t -> new HashMap()).put(component.getKey().toLowerCase(), component.getClass());
    }

    static {
        ComponentRegistry.register(new AirTrigger());
        ComponentRegistry.register(new ArmorEquipTrigger());
        ComponentRegistry.register(new AttributeChangeTrigger());
        ComponentRegistry.register(new BlockBreakTrigger());
        ComponentRegistry.register(new BlockPlaceTrigger());
        ComponentRegistry.register(new ChatTrigger());
        ComponentRegistry.register(new ClickLeftTrigger());
        ComponentRegistry.register(new ClickRightTrigger());
        ComponentRegistry.register(new ConsumeTrigger());
        ComponentRegistry.register(new CrouchTrigger());
        ComponentRegistry.register(new DeathTrigger());
        ComponentRegistry.register(new DropItemTrigger());
        ComponentRegistry.register(new EntityResurrectTrigger());
        ComponentRegistry.register(new EntityTargetTrigger());
        ComponentRegistry.register(new EnvironmentalTrigger());
        ComponentRegistry.register(new ExperienceTrigger());
        ComponentRegistry.register(new FishingBiteTrigger());
        ComponentRegistry.register(new FishingFailTrigger());
        ComponentRegistry.register(new FishingFishTrigger());
        ComponentRegistry.register(new FishingGrabTrigger());
        ComponentRegistry.register(new FishingGroundTrigger());
        ComponentRegistry.register(new FishingReelTrigger());
        ComponentRegistry.register(new FlagTrigger());
        ComponentRegistry.register(new FlagExpireTrigger());
        ComponentRegistry.register(new FlightToggleTrigger());
        ComponentRegistry.register(new GlideTrigger());
        ComponentRegistry.register(new HarvestTrigger());
        ComponentRegistry.register(new HealTrigger());
        ComponentRegistry.register(new ItemSwapTrigger());
        ComponentRegistry.register(new JumpTrigger());
        ComponentRegistry.register(new KillTrigger());
        ComponentRegistry.register(new LandTrigger());
        ComponentRegistry.register(new LaunchTrigger());
        ComponentRegistry.register(new MoveTrigger());
        ComponentRegistry.register(new PhysicalDealtTrigger());
        ComponentRegistry.register(new PhysicalTakenTrigger());
        ComponentRegistry.register(new ProjectileHitTrigger());
        ComponentRegistry.register(new ProjectileTickTrigger());
        ComponentRegistry.register(new RiptideTrigger());
        ComponentRegistry.register(new ShearTrigger());
        ComponentRegistry.register(new ShieldTrigger());
        ComponentRegistry.register(new SkillUpgradeTrigger());
        ComponentRegistry.register(new SignalTrigger());
        ComponentRegistry.register(new SprintTrigger());
        ComponentRegistry.register(new SkillCastTrigger());
        ComponentRegistry.register(new SkillDealtTrigger());
        ComponentRegistry.register(new SkillTakenTrigger());
        ComponentRegistry.register(new StripLogTrigger());
        ComponentRegistry.register(new WorldChangeTrigger());
        ComponentRegistry.register(new AreaTarget());
        ComponentRegistry.register(new ConeTarget());
        ComponentRegistry.register(new LinearTarget());
        ComponentRegistry.register(new LocationTarget());
        ComponentRegistry.register(new NearestTarget());
        ComponentRegistry.register(new OffsetTarget());
        ComponentRegistry.register(new RememberTarget());
        ComponentRegistry.register(new SelfTarget());
        ComponentRegistry.register(new SingleTarget());
        ComponentRegistry.register(new ActionBarCondition());
        ComponentRegistry.register(new AirCondition());
        ComponentRegistry.register(new AltitudeCondition());
        ComponentRegistry.register(new ArmorCondition());
        ComponentRegistry.register(new AttackIndicatorCondition());
        ComponentRegistry.register(new AttributeCondition());
        ComponentRegistry.register(new BiomeCondition());
        ComponentRegistry.register(new BlockCondition());
        ComponentRegistry.register(new BlockingCondition());
        ComponentRegistry.register(new BurningCondition());
        ComponentRegistry.register(new CastLevelCondition());
        ComponentRegistry.register(new CeilingCondition());
        ComponentRegistry.register(new ChanceCondition());
        ComponentRegistry.register(new ClassCondition());
        ComponentRegistry.register(new ClassLevelCondition());
        ComponentRegistry.register(new ColorCondition());
        ComponentRegistry.register(new CombatCondition());
        ComponentRegistry.register(new CrouchCondition());
        ComponentRegistry.register(new DirectionCondition());
        ComponentRegistry.register(new DistanceCondition());
        ComponentRegistry.register(new ElevationCondition());
        ComponentRegistry.register(new ElseCondition());
        ComponentRegistry.register(new EntityTypeCondition());
        ComponentRegistry.register(new FireCondition());
        ComponentRegistry.register(new FlagCondition());
        ComponentRegistry.register(new FoodCondition());
        ComponentRegistry.register(new GlideCondition());
        ComponentRegistry.register(new GroundCondition());
        ComponentRegistry.register(new HealthCondition());
        ComponentRegistry.register(new InventoryCondition());
        ComponentRegistry.register(new ItemCondition());
        ComponentRegistry.register(new LightCondition());
        ComponentRegistry.register(new LoreCondition());
        ComponentRegistry.register(new ManaCondition());
        ComponentRegistry.register(new MoneyCondition());
        ComponentRegistry.register(new MoonCondition());
        ComponentRegistry.register(new MountedCondition());
        ComponentRegistry.register(new MountingCondition());
        ComponentRegistry.register(new MythicMobTypeCondition());
        ComponentRegistry.register(new NameCondition());
        ComponentRegistry.register(new OffhandCondition());
        ComponentRegistry.register(new PermissionCondition());
        ComponentRegistry.register(new PotionCondition());
        ComponentRegistry.register(new SkillLevelCondition());
        ComponentRegistry.register(new SlotCondition());
        ComponentRegistry.register(new SprintCondition());
        ComponentRegistry.register(new StatusCondition());
        ComponentRegistry.register(new TimeCondition());
        ComponentRegistry.register(new ToolCondition());
        ComponentRegistry.register(new ValueCondition());
        ComponentRegistry.register(new ValueTextCondition());
        ComponentRegistry.register(new WaterCondition());
        ComponentRegistry.register(new WeatherCondition());
        ComponentRegistry.register(new WorldCondition());
        ComponentRegistry.register(new YawCondition());
        ComponentRegistry.register(new AbortSkillMechanic());
        ComponentRegistry.register(new AirModifyMechanic());
        ComponentRegistry.register(new AirSetMechanic());
        ComponentRegistry.register(new ArmorMechanic());
        ComponentRegistry.register(new ArmorStandMechanic());
        ComponentRegistry.register(new ArmorStandPoseMechanic());
        ComponentRegistry.register(new ArmorStandRemoveMechanic());
        ComponentRegistry.register(new AttributeMechanic());
        ComponentRegistry.register(new BlockMechanic());
        ComponentRegistry.register(new BuffMechanic());
        ComponentRegistry.register(new CancelEffectMechanic());
        ComponentRegistry.register(new CancelMechanic());
        ComponentRegistry.register(new ChannelMechanic());
        ComponentRegistry.register(new CleanseMechanic());
        ComponentRegistry.register(new CommandMechanic());
        ComponentRegistry.register(new CooldownMechanic());
        ComponentRegistry.register(new DamageBuffMechanic());
        ComponentRegistry.register(new DamageLoreMechanic());
        ComponentRegistry.register(new DamageMechanic());
        ComponentRegistry.register(new DefenseBuffMechanic());
        ComponentRegistry.register(new DelayMechanic());
        ComponentRegistry.register(new DisguiseMechanic());
        ComponentRegistry.register(new DurabilityMechanic());
        ComponentRegistry.register(new ExperienceMechanic());
        ComponentRegistry.register(new ExplosionMechanic());
        ComponentRegistry.register(new FireMechanic());
        ComponentRegistry.register(new FlagClearMechanic());
        ComponentRegistry.register(new FlagMechanic());
        ComponentRegistry.register(new FlagToggleMechanic());
        ComponentRegistry.register(new FlyMechanic());
        ComponentRegistry.register(new FoodMechanic());
        ComponentRegistry.register(new ForgetTargetsMechanic());
        ComponentRegistry.register(new HealMechanic());
        ComponentRegistry.register(new HealthSetMechanic());
        ComponentRegistry.register(new HeldItemMechanic());
        ComponentRegistry.register(new ImmunityMechanic());
        ComponentRegistry.register(new InterruptMechanic());
        ComponentRegistry.register(new InvisibilityMechanic());
        ComponentRegistry.register(new ItemDropMechanic());
        ComponentRegistry.register(new ItemMechanic());
        ComponentRegistry.register(new ItemProjectileMechanic());
        ComponentRegistry.register(new ItemRemoveMechanic());
        ComponentRegistry.register(new LaunchMechanic());
        ComponentRegistry.register(new LightningMechanic());
        ComponentRegistry.register(new ManaMechanic());
        ComponentRegistry.register(new MessageMechanic());
        ComponentRegistry.register(new MineMechanic());
        ComponentRegistry.register(new MoneyMechanic());
        ComponentRegistry.register(new MountMechanic());
        ComponentRegistry.register(new MythicMobSkill());
        ComponentRegistry.register(new ParticleAnimationMechanic());
        ComponentRegistry.register(new ParticleEffectMechanic());
        ComponentRegistry.register(new ParticleImageMechanic());
        ComponentRegistry.register(new ParticleMechanic());
        ComponentRegistry.register(new ParticleProjectileMechanic());
        ComponentRegistry.register(new PassiveMechanic());
        ComponentRegistry.register(new PermissionMechanic());
        ComponentRegistry.register(new PotionMechanic());
        ComponentRegistry.register(new PotionProjectileMechanic());
        ComponentRegistry.register(new ProjectileMechanic());
        ComponentRegistry.register(new PurgeMechanic());
        ComponentRegistry.register(new PushMechanic());
        ComponentRegistry.register(new RememberTargetsMechanic());
        ComponentRegistry.register(new RepeatMechanic());
        ComponentRegistry.register(new ShieldMechanic());
        ComponentRegistry.register(new SignalEmitMechanic());
        ComponentRegistry.register(new SkillCastMechanic());
        ComponentRegistry.register(new SoundMechanic());
        ComponentRegistry.register(new StatMechanic());
        ComponentRegistry.register(new StatusMechanic());
        ComponentRegistry.register(new SummonMechanic());
        ComponentRegistry.register(new TauntMechanic());
        ComponentRegistry.register(new ThrowMechanic());
        ComponentRegistry.register(new TriggerMechanic());
        ComponentRegistry.register(new ValueAddMechanic());
        ComponentRegistry.register(new ValueAttributeMechanic());
        ComponentRegistry.register(new ValueCopyMechanic());
        ComponentRegistry.register(new ValueDistanceMechanic());
        ComponentRegistry.register(new ValueDivideMechanic());
        ComponentRegistry.register(new ValueHealthMechanic());
        ComponentRegistry.register(new ValueLoadMechanic());
        ComponentRegistry.register(new ValueLocationMechanic());
        ComponentRegistry.register(new ValueLoreMechanic());
        ComponentRegistry.register(new ValueLoreSlotMechanic());
        ComponentRegistry.register(new ValueManaMechanic());
        ComponentRegistry.register(new ValueMathMechanic());
        ComponentRegistry.register(new ValueMultiplyMechanic());
        ComponentRegistry.register(new ValuePlaceholderMechanic());
        ComponentRegistry.register(new ValueRandomMechanic());
        ComponentRegistry.register(new ValueRotationMechanic());
        ComponentRegistry.register(new ValueRoundMechanic());
        ComponentRegistry.register(new ValueSetMechanic());
        ComponentRegistry.register(new WarpLocMechanic());
        ComponentRegistry.register(new WarpMechanic());
        ComponentRegistry.register(new WarpRandomMechanic());
        ComponentRegistry.register(new WarpSwapMechanic());
        ComponentRegistry.register(new WarpTargetMechanic());
        ComponentRegistry.register(new WarpValueMechanic());
        ComponentRegistry.register(new WolfMechanic());
    }
}

