/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.mccore.commands.CommandManager;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.codex.mccore.config.Filter;
import studio.magemonkey.codex.mccore.config.parse.NumberParser;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.enums.ExpSource;
import studio.magemonkey.fabled.api.player.PlayerClass;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.cmd.api.NumericAction;
import studio.magemonkey.fabled.language.RPGFilter;
import studio.magemonkey.fabled.manager.CmdManager;

public class CmdExp
implements IFunction,
TabCompleter {
    public static final Pattern IS_NUMBER = Pattern.compile("-?[0-9]+");
    public static final Pattern IS_BOOL = Pattern.compile("(true)|(false)");
    private static final String NOT_PLAYER = "not-player";
    private static final String GAVE_EXP = "gave-exp";
    private static final String TOOK_EXP = "took-exp";
    private static final String DISABLED = "world-disabled";

    public void execute(ConfigurableCommand cmd, Plugin plugin, CommandSender sender, String[] args, boolean silent) {
        int lastArg;
        NumericAction action;
        OfflinePlayer target;
        int numberIndex = this.getNumberIndex(args);
        if (!(sender instanceof Player)) {
            if (args.length < 3) {
                CommandManager.displayUsage((ConfigurableCommand)cmd, (CommandSender)sender);
                return;
            }
            target = Bukkit.getOfflinePlayer((String)args[0]);
        } else {
            if (!Fabled.getSettings().isWorldEnabled(((Player)sender).getWorld()) && args.length == 2) {
                cmd.sendMessage(sender, DISABLED, "&4You cannot use this command in this world", silent, new CustomFilter[0]);
                return;
            }
            if (args.length < 2) {
                CommandManager.displayUsage((ConfigurableCommand)cmd, (CommandSender)sender);
                return;
            }
            OfflinePlayer offlinePlayer = target = numberIndex == 1 ? (OfflinePlayer)sender : Bukkit.getOfflinePlayer((String)args[0]);
        }
        if (target == null) {
            cmd.sendMessage(sender, NOT_PLAYER, String.valueOf(ChatColor.RED) + "That is not a valid player name", silent, new CustomFilter[0]);
            return;
        }
        PlayerData data = Fabled.getData(target);
        try {
            action = NumericAction.valueOf(args[numberIndex - 1].toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            CommandManager.displayUsage((ConfigurableCommand)cmd, (CommandSender)sender);
            return;
        }
        double amount = NumberParser.parseDouble((String)args[numberIndex]);
        if (amount == 0.0) {
            return;
        }
        if (action == NumericAction.REMOVE) {
            amount = -amount;
        }
        if (numberIndex + 1 <= (lastArg = args.length - 1)) {
            PlayerClass playerClass = data.getClass(CmdManager.join(args, numberIndex + 1, lastArg));
            if (playerClass == null) {
                CommandManager.displayUsage((ConfigurableCommand)cmd, (CommandSender)sender);
                return;
            }
            if (action == NumericAction.SET) {
                amount -= playerClass.getTotalExp();
            }
            if (amount > 0.0) {
                playerClass.giveExp(amount, ExpSource.COMMAND, !silent);
                if (target != sender) {
                    cmd.sendMessage(sender, GAVE_EXP, String.valueOf(ChatColor.DARK_GREEN) + "You have given " + String.valueOf(ChatColor.GOLD) + "{player} {exp}{class} experience", silent, new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName()), RPGFilter.EXP.setReplacement("" + amount), RPGFilter.CLASS.setReplacement(" " + playerClass.getData().getGroup())});
                }
            } else {
                playerClass.loseExp(-amount, false, true, !silent);
                if (target != sender) {
                    cmd.sendMessage(sender, TOOK_EXP, String.valueOf(ChatColor.DARK_GREEN) + "You have taken " + String.valueOf(ChatColor.GOLD) + "{exp}{class} experience " + String.valueOf(ChatColor.DARK_GREEN) + "from " + String.valueOf(ChatColor.GOLD) + "{player}", silent, new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName()), RPGFilter.EXP.setReplacement("" + -amount), RPGFilter.CLASS.setReplacement(" " + playerClass.getData().getGroup())});
                }
            }
        } else {
            if (action == NumericAction.SET) {
                data.setExp(amount, ExpSource.COMMAND, !silent);
            }
            if (amount > 0.0) {
                data.giveExp(amount, ExpSource.COMMAND, !silent);
                if (target != sender) {
                    cmd.sendMessage(sender, GAVE_EXP, String.valueOf(ChatColor.DARK_GREEN) + "You have given " + String.valueOf(ChatColor.GOLD) + "{player} {exp}{class} experience", silent, new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName()), RPGFilter.EXP.setReplacement("" + amount), RPGFilter.CLASS.setReplacement("")});
                }
            } else {
                data.loseExp(-amount, false, true, !silent);
                if (target != sender) {
                    cmd.sendMessage(sender, TOOK_EXP, String.valueOf(ChatColor.DARK_GREEN) + "You have taken " + String.valueOf(ChatColor.GOLD) + "{exp}{class} experience " + String.valueOf(ChatColor.DARK_GREEN) + "from " + String.valueOf(ChatColor.GOLD) + "{player}", silent, new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName()), RPGFilter.EXP.setReplacement("" + -amount), RPGFilter.CLASS.setReplacement("")});
                }
            }
        }
    }

    private int getNumberIndex(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!IS_NUMBER.matcher(args[i]).matches()) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length > 0) {
            args = (String[])Arrays.stream(args).filter(arg -> !arg.equalsIgnoreCase("-s") && !arg.equalsIgnoreCase("--silent")).toArray(String[]::new);
        }
        if (args.length == 1) {
            ArrayList<String> list = new ArrayList<String>(ConfigurableCommand.getPlayerTabCompletions((CommandSender)commandSender, (String)args[0]));
            list.add("add");
            list.add("remove");
            list.add("set");
            return list;
        }
        if (args.length == 2) {
            if (!(args[args.length - 2].equalsIgnoreCase("add") || args[args.length - 2].equalsIgnoreCase("set") || args[args.length - 2].equalsIgnoreCase("remove"))) {
                return List.of("add", "remove", "set");
            }
            return List.of("<exp>");
        }
        if (args.length > 2) {
            int numberIndex = this.getNumberIndex(args);
            if (numberIndex == -1) {
                return List.of("<exp>");
            }
            return ConfigurableCommand.getTabCompletions(Fabled.getGroups(), (String[])Arrays.copyOfRange(args, numberIndex + 1, args.length));
        }
        return null;
    }
}

