/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api.particle;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import lombok.Generated;
import org.bukkit.Color;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.api.particle.EffectInstance;
import studio.magemonkey.fabled.api.particle.EffectManager;
import studio.magemonkey.fabled.api.particle.ParticleImage;
import studio.magemonkey.fabled.api.particle.TimeBasedTransform;
import studio.magemonkey.fabled.api.particle.target.EffectTarget;
import studio.magemonkey.fabled.data.Point3D;
import studio.magemonkey.fabled.data.formula.Formula;
import studio.magemonkey.fabled.data.formula.value.CustomValue;

public class EffectImage {
    private static final String IMG = "img";
    public static final String INTERVAL = "interval";
    public static final String ITER_PER_FRAME = "iterations-per-frame";
    public static final String VIEW_RANGE = "view-range";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String LOCK_ASPECT = "lock-aspect";
    private static final String RESOLUTION = "resolution";
    private static final String DUST_SIZE = "dust-size";
    private static final String WITH_ROTATION = "with-rotation";
    private final Settings settings;

    public EffectImage(Settings settings) {
        this.settings = settings;
    }

    public void start(EffectTarget target, String key, int ticks, int level) {
        EffectInstance instance = EffectManager.getEffect(target, key);
        if (instance != null) {
            instance.extend(ticks);
            return;
        }
        if (EffectManager.getEffect(key) == null) {
            this.makeEffect(key);
        }
        EffectManager.runEffect(EffectManager.getEffect(key), target, ticks, level);
    }

    private void makeEffect(String key) {
        String fileName = this.settings.getString(IMG, "default.png");
        File file = new File(Fabled.inst().getDataFolder(), "images" + File.separator + fileName);
        if (!file.exists()) {
            Fabled.inst().getLogger().warning("Image file not found: " + file.getPath());
            return;
        }
        Formula dustSizeFormula = new Formula(this.settings.getString(DUST_SIZE, "1"), new CustomValue("t"), new CustomValue("l"));
        ImageData imgData = this.readImage(file);
        if (imgData == null) {
            Fabled.inst().getLogger().warning("Failed to read image file: " + file.getPath());
            return;
        }
        ParticleImage effect = new ParticleImage(key, imgData.getColors(), imgData.getPoints(), dustSizeFormula, this.settings.getInt(INTERVAL, 5), this.settings.getInt(ITER_PER_FRAME, 3), this.settings.getInt(VIEW_RANGE, 25), this.settings.getBool(WITH_ROTATION, false), new TimeBasedTransform(this.settings));
        EffectManager.register(effect);
    }

    private ImageData readImage(File file) {
        BufferedImage original;
        if (file.getName().endsWith(".gif")) {
            return this.readGif(file);
        }
        try {
            original = ImageIO.read(file);
        }
        catch (IOException e) {
            Fabled.inst().getLogger().warning("Failed to read image file: " + file.getPath() + " (" + e.getMessage() + ")");
            e.printStackTrace();
            return null;
        }
        int resolution = this.settings.getInt(RESOLUTION, 6);
        boolean lockAspect = this.settings.getBool(LOCK_ASPECT, true);
        int width = this.settings.getInt(WIDTH, 3) * resolution;
        int height = this.settings.getInt(HEIGHT, width / resolution) * resolution;
        if (lockAspect) {
            double aspect = (double)original.getWidth() / (double)original.getHeight();
            if (aspect > 1.0) {
                width = (int)((double)width * aspect);
            } else {
                height = (int)((double)height / aspect);
            }
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        image.getGraphics().drawImage(original.getScaledInstance(width, height, 4), 0, 0, null);
        Color[][] colors = new Color[1][width * height];
        Point3D[][] points = new Point3D[1][width * height];
        FrameData frameData = this.getFrameData(image, resolution);
        colors[0] = frameData.getColors();
        points[0] = frameData.getPoints();
        return new ImageData(colors, points);
    }

    private ImageData readGif(File file) {
        try {
            ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
            ImageInputStream stream = ImageIO.createImageInputStream(file);
            reader.setInput(stream);
            BufferedImage image = reader.read(0);
            int resolution = this.settings.getInt(RESOLUTION, 6);
            boolean lockAspect = this.settings.getBool(LOCK_ASPECT, true);
            int width = this.settings.getInt(WIDTH, 3) * resolution;
            int height = this.settings.getInt(HEIGHT, width / resolution) * resolution;
            if (lockAspect) {
                double aspect = (double)image.getWidth() / (double)image.getHeight();
                if (aspect > 1.0) {
                    width = (int)((double)width * aspect);
                } else {
                    height = (int)((double)height / aspect);
                }
            }
            int frames = reader.getNumImages(true);
            Color[][] colors = new Color[frames][width * height];
            Point3D[][] points = new Point3D[frames][width * height];
            for (int index = 0; index < frames; ++index) {
                BufferedImage frameImage = reader.read(index);
                BufferedImage frame = new BufferedImage(width, height, 2);
                frame.getGraphics().drawImage(frameImage.getScaledInstance(width, height, 4), 0, 0, null);
                FrameData data = this.getFrameData(frame, resolution);
                colors[index] = data.getColors();
                points[index] = data.getPoints();
            }
            return new ImageData(colors, points);
        }
        catch (IOException ex) {
            return null;
        }
    }

    private FrameData getFrameData(BufferedImage img, int resolution) {
        int width = img.getWidth();
        int height = img.getHeight();
        Color[] colors = new Color[width * height];
        Point3D[] points = new Point3D[width * height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                Color col;
                double relativeX = ((double)x - (double)width / 2.0) / (double)resolution;
                double relativeY = ((double)y - (double)height / 2.0) / (double)resolution;
                points[x + y * width] = new Point3D(relativeX, relativeY, 0.0);
                int color = img.getRGB(width - x - 1, height - y - 1);
                if ((color & 0xFF000000) == 0) continue;
                colors[x + y * width] = col = Color.fromRGB((int)(color &= 0xFFFFFF));
            }
        }
        return new FrameData(colors, points);
    }

    private static class ImageData {
        private final Color[][] colors;
        private final Point3D[][] points;

        @Generated
        public Color[][] getColors() {
            return this.colors;
        }

        @Generated
        public Point3D[][] getPoints() {
            return this.points;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImageData)) {
                return false;
            }
            ImageData other = (ImageData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals((Object[])this.getColors(), (Object[])other.getColors())) {
                return false;
            }
            return Arrays.deepEquals((Object[])this.getPoints(), (Object[])other.getPoints());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ImageData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode((Object[])this.getColors());
            result = result * 59 + Arrays.deepHashCode((Object[])this.getPoints());
            return result;
        }

        @Generated
        public String toString() {
            return "EffectImage.ImageData(colors=" + Arrays.deepToString((Object[])this.getColors()) + ", points=" + Arrays.deepToString((Object[])this.getPoints()) + ")";
        }

        @Generated
        public ImageData(Color[][] colors, Point3D[][] points) {
            this.colors = colors;
            this.points = points;
        }
    }

    private static class FrameData {
        private final Color[] colors;
        private final Point3D[] points;

        @Generated
        public Color[] getColors() {
            return this.colors;
        }

        @Generated
        public Point3D[] getPoints() {
            return this.points;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FrameData)) {
                return false;
            }
            FrameData other = (FrameData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getColors(), other.getColors())) {
                return false;
            }
            return Arrays.deepEquals(this.getPoints(), other.getPoints());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FrameData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getColors());
            result = result * 59 + Arrays.deepHashCode(this.getPoints());
            return result;
        }

        @Generated
        public String toString() {
            return "EffectImage.FrameData(colors=" + Arrays.deepToString(this.getColors()) + ", points=" + Arrays.deepToString(this.getPoints()) + ")";
        }

        @Generated
        public FrameData(Color[] colors, Point3D[] points) {
            this.colors = colors;
            this.points = points;
        }
    }
}

