/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.thread;

import java.util.Iterator;
import studio.magemonkey.fabled.thread.IThreadTask;

public class TaskList
implements Iterable<IThreadTask>,
Iterator<IThreadTask> {
    private Entry iteratee;
    private Entry head;
    private Entry tail;
    private int size;

    public TaskList() {
        this.head = this.tail = new Entry();
    }

    public int size() {
        return this.size;
    }

    public void add(IThreadTask task) {
        this.tail.next = new Entry(task);
        this.tail.next.prev = this.tail;
        this.tail = this.tail.next;
        ++this.size;
    }

    public void clear() {
        this.head.next = null;
        this.tail = this.head;
        this.size = 0;
    }

    @Override
    public Iterator<IThreadTask> iterator() {
        this.iteratee = this.head;
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.iteratee.next != null;
    }

    @Override
    public IThreadTask next() {
        if (this.iteratee == null || this.iteratee.next == null) {
            return null;
        }
        this.iteratee = this.iteratee.next;
        return this.iteratee.task;
    }

    @Override
    public void remove() {
        Entry next = this.iteratee.next;
        Entry prev = this.iteratee.prev;
        if (prev == null) {
            this.head = next;
        } else {
            prev.next = next;
            this.iteratee.prev = null;
        }
        if (next == null) {
            this.tail = prev;
        } else {
            next.prev = prev;
            this.iteratee.next = null;
        }
        this.iteratee.task = null;
        --this.size;
    }

    private static class Entry {
        private IThreadTask task;
        private Entry prev;
        private Entry next;

        public Entry() {
        }

        public Entry(IThreadTask task) {
            this.task = task;
        }
    }
}

