/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.listener;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import studio.magemonkey.codex.api.armor.ArmorEquipEvent;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.codex.mccore.config.FilterType;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.DefaultCombatProtection;
import studio.magemonkey.fabled.api.event.PlayerClassChangeEvent;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.data.PlayerEquips;
import studio.magemonkey.fabled.listener.FabledListener;
import studio.magemonkey.fabled.listener.MainListener;

public class ItemListener
extends FabledListener {
    public static final Set<Material> ARMOR_TYPES = ItemListener.getArmorMaterials();

    private static Set<Material> getArmorMaterials() {
        ImmutableSet armorSuffixes = ImmutableSet.of((Object)"BOOTS", (Object)"LEGGINGS", (Object)"CHESTPLATE", (Object)"HELMET");
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Material material : Material.values()) {
            int index = material.name().lastIndexOf(95) + 1;
            String suffix = material.name().substring(index);
            if (!armorSuffixes.contains(suffix)) continue;
            builder.add((Object)material);
        }
        return builder.build();
    }

    @Override
    public void init() {
        MainListener.registerJoin(this::onJoin);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDrop(PlayerDropItemEvent event) {
        if (Fabled.getSettings().isWorldEnabled(event.getPlayer().getWorld())) {
            Player player = event.getPlayer();
            PlayerData playerData = Fabled.getData((OfflinePlayer)player);
            playerData.getEquips().update(player);
            playerData.updatePlayerStat(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBreak(PlayerItemBreakEvent event) {
        PlayerData playerData;
        Player player = event.getPlayer();
        if (Fabled.getSettings().isWorldEnabled(player.getWorld()) && (playerData = Fabled.getData((OfflinePlayer)player)).getEquips().updateHandHeldItem(player, null)) {
            playerData.updatePlayerStat(player);
        }
    }

    public void onJoin(Player player) {
        if (Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            Fabled.getData((OfflinePlayer)player).getEquips().update(player);
        }
    }

    @EventHandler
    public void onProfess(PlayerClassChangeEvent event) {
        Player player = event.getPlayerData().getPlayer();
        if (Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            event.getPlayerData().getEquips().update(player);
        }
    }

    @EventHandler
    public void onPickup(EntityPickupItemEvent event) {
        LivingEntity ent = event.getEntity();
        if (!(ent instanceof Player)) {
            return;
        }
        final Player player = (Player)ent;
        if (Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            Fabled.schedule(new BukkitRunnable(){

                public void run() {
                    PlayerData playerData = Fabled.getData((OfflinePlayer)player);
                    if (playerData.getEquips().update(player)) {
                        playerData.updatePlayerStat(player);
                    }
                }
            }, 1);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorld(PlayerChangedWorldEvent event) {
        if (!Fabled.getSettings().isWorldEnabled(event.getFrom()) && Fabled.getSettings().isWorldEnabled(event.getPlayer().getWorld())) {
            Fabled.getData((OfflinePlayer)event.getPlayer()).getEquips().update(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHeld(PlayerItemHeldEvent event) {
        PlayerData playerData;
        Player player = event.getPlayer();
        if (Fabled.getSettings().isWorldEnabled(player.getWorld()) && (playerData = Fabled.getData((OfflinePlayer)player)).getEquips().updateHandHeldItem(player, player.getInventory().getItem(event.getNewSlot()))) {
            playerData.updatePlayerStat(player);
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        PlayerData playerData;
        Player player = (Player)event.getPlayer();
        if (Fabled.getSettings().isWorldEnabled(player.getWorld()) && (playerData = Fabled.getData((OfflinePlayer)player)).getEquips().update(player)) {
            playerData.updatePlayerStat(player);
        }
    }

    private int getArmorSlot(Material mat) {
        if (mat.name().contains("CHESTPLATE")) {
            return 38;
        }
        if (mat.name().contains("LEGGINGS")) {
            return 37;
        }
        if (mat.name().contains("BOOTS")) {
            return 36;
        }
        return 39;
    }

    @EventHandler
    public void armorEquip(ArmorEquipEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getNewArmorPiece();
        if (Fabled.getSettings().isWorldEnabled(player.getWorld()) && item != null && ARMOR_TYPES.contains(item.getType())) {
            int slot = this.getArmorSlot(item.getType());
            PlayerData playerData = Fabled.getData((OfflinePlayer)player);
            PlayerEquips.EquipData data = playerData.getEquips().getEquipData(item, PlayerEquips.EquipType.fromSlot(slot));
            if (!data.hasMetConditions()) {
                event.setCancelled(true);
                Fabled.getLanguage().sendMessage("Errors.cannot-use", (CommandSender)player, FilterType.COLOR, new CustomFilter[0]);
                return;
            }
            playerData.getEquips().updateEquip(player, slot, item);
            playerData.updatePlayerStat(player);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onAttack(EntityDamageByEntityEvent event) {
        Player player;
        if (!Fabled.getSettings().isWorldEnabled(event.getEntity().getWorld()) || DefaultCombatProtection.isFakeDamageEvent(event)) {
            return;
        }
        if (event.getDamager() instanceof Player && !Fabled.getData((OfflinePlayer)(player = (Player)event.getDamager())).getEquips().canHit()) {
            Fabled.getLanguage().sendMessage("Errors.cannot-use", (CommandSender)player, FilterType.COLOR, new CustomFilter[0]);
            event.setCancelled(true);
        }
        if (event.getEntity() instanceof Player) {
            boolean blocking;
            player = (Player)event.getEntity();
            boolean bl = blocking = event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0;
            if (blocking && !Fabled.getData((OfflinePlayer)player).getEquips().canBlock()) {
                Fabled.getLanguage().sendMessage("Errors.cannot-use", (CommandSender)event.getEntity(), FilterType.COLOR, new CustomFilter[0]);
                event.setDamage(EntityDamageEvent.DamageModifier.BLOCKING, 0.0);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onShoot(EntityShootBowEvent event) {
        if (!Fabled.getSettings().isWorldEnabled(event.getEntity().getWorld())) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            PlayerEquips equips = Fabled.getData((OfflinePlayer)((Player)event.getEntity())).getEquips();
            if (this.isMainhand(event.getBow(), event.getEntity())) {
                if (!equips.canHit()) {
                    Fabled.getLanguage().sendMessage("Errors.cannot-use", (CommandSender)event.getEntity(), FilterType.COLOR, new CustomFilter[0]);
                    event.setCancelled(true);
                }
            } else if (!equips.canBlock()) {
                Fabled.getLanguage().sendMessage("Errors.cannot-use", (CommandSender)event.getEntity(), FilterType.COLOR, new CustomFilter[0]);
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        Player player;
        PlayerEquips equips;
        if (!Fabled.getSettings().isWorldEnabled(event.getEntity().getWorld())) {
            return;
        }
        ProjectileSource shooter = event.getEntity().getShooter();
        if (shooter instanceof Player && !(equips = Fabled.getData((OfflinePlayer)(player = (Player)shooter)).getEquips()).canHit()) {
            Fabled.getLanguage().sendMessage("Errors.cannot-use", (CommandSender)player, FilterType.COLOR, new CustomFilter[0]);
            event.setCancelled(true);
        }
    }

    private boolean isMainhand(ItemStack bow, LivingEntity entity) {
        ItemStack item = entity.getEquipment().getItemInMainHand();
        return bow == item || bow.equals((Object)item);
    }
}

