/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.listener;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.event.PlayerAccountChangeEvent;
import studio.magemonkey.fabled.api.event.PlayerClassChangeEvent;
import studio.magemonkey.fabled.api.event.PlayerSkillDowngradeEvent;
import studio.magemonkey.fabled.api.event.PlayerSkillUnlockEvent;
import studio.magemonkey.fabled.api.event.PlayerSkillUpgradeEvent;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.player.PlayerSkillBar;
import studio.magemonkey.fabled.api.skills.Skill;
import studio.magemonkey.fabled.gui.handlers.SkillHandler;
import studio.magemonkey.fabled.hook.CitizensHook;
import studio.magemonkey.fabled.listener.FabledListener;
import studio.magemonkey.fabled.listener.MainListener;

public class CastCombatListener
extends FabledListener {
    private final Map<UUID, ItemStack[]> backup = new HashMap<UUID, ItemStack[]>();
    private final Set<UUID> ignored = new HashSet<UUID>();
    private final int slot = Fabled.getSettings().getCastSlot();

    @Override
    public void init() {
        MainListener.registerJoin(this::init);
        MainListener.registerClear(this::handleClear);
        Bukkit.getOnlinePlayers().forEach(this::init);
    }

    @Override
    public void cleanup() {
        Bukkit.getOnlinePlayers().stream().filter(player -> Fabled.getSettings().isWorldEnabled(player.getWorld())).forEach(this::cleanup);
    }

    private void init(Player player) {
        if (!Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            return;
        }
        PlayerData data = Fabled.getData((OfflinePlayer)player);
        this.backup.put(player.getUniqueId(), new ItemStack[9]);
        if (Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            PlayerInventory inv = player.getInventory();
            ItemStack item = inv.getItem(this.slot);
            inv.setItem(this.slot, Fabled.getSettings().getCastItem());
            if (item != null && item.getType() != Material.AIR) {
                for (ItemStack overflow : inv.addItem(new ItemStack[]{item}).values()) {
                    player.getWorld().dropItemNaturally(player.getLocation(), overflow);
                }
            }
            inv.getItem(this.slot).setAmount(1);
            int playerSlot = player.getInventory().getHeldItemSlot();
            int tries = 0;
            while (!data.getSkillBar().isWeaponSlot(playerSlot) || this.slot == playerSlot) {
                playerSlot = (playerSlot + 1) % 9;
                if (++tries <= 9) continue;
                Fabled.inst().getLogger().warning("You appear to have casting bars enabled, but don't have a slot for the player to equip a weapon. We're disabling cast bars until this is resolved.");
                break;
            }
            if (playerSlot != player.getInventory().getHeldItemSlot()) {
                player.getInventory().setHeldItemSlot(playerSlot);
            }
        }
    }

    private void cleanup(Player player) {
        this.ignored.remove(player.getUniqueId());
        PlayerData data = Fabled.getData((OfflinePlayer)player);
        PlayerSkillBar bar = data.getSkillBar();
        if (bar.isSetup()) {
            this.toggle(player);
        }
        player.getInventory().setItem(this.slot, null);
        this.backup.remove(player.getUniqueId());
    }

    private void toggle(Player player) {
        int i;
        ItemStack[] items = this.backup.get(player.getUniqueId());
        if (items == null) {
            items = new ItemStack[9];
        }
        ItemStack[] temp = new ItemStack[9];
        PlayerData data = Fabled.getData((OfflinePlayer)player);
        for (i = 0; i < items.length; ++i) {
            if (i == this.slot || data.getSkillBar().isSetup() && !data.getSkillBar().isWeaponSlot(i)) continue;
            temp[i] = player.getInventory().getItem(i);
            player.getInventory().setItem(i, null);
        }
        this.backup.put(player.getUniqueId(), temp);
        if (data.getSkillBar().isSetup()) {
            data.getSkillBar().clear(player);
        } else {
            data.getSkillBar().setup((HumanEntity)player);
        }
        for (i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            player.getInventory().setItem(i, items[i]);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent event) {
        if (Fabled.getSettings().isWorldEnabled(event.getPlayer().getWorld())) {
            this.cleanup(event.getPlayer());
        }
    }

    @EventHandler
    public void onProfess(PlayerClassChangeEvent event) {
        Player p = event.getPlayerData().getPlayer();
        if (event.getPreviousClass() != null && event.getNewClass() == null) {
            PlayerSkillBar bar = event.getPlayerData().getSkillBar();
            bar.reset();
            bar.clear(p);
        }
    }

    @EventHandler
    public void onUnlock(PlayerSkillUnlockEvent event) {
        if (!event.getUnlockedSkill().getData().canCast() || event.getPlayerData().getPlayer() == null) {
            return;
        }
        event.getPlayerData().getSkillBar().unlock(event.getUnlockedSkill());
    }

    @EventHandler
    public void onUpgrade(PlayerSkillUpgradeEvent event) {
        Player player = event.getPlayerData().getPlayer();
        if (player != null && event.getPlayerData().getSkillBar().isSetup()) {
            Fabled.schedule(() -> event.getPlayerData().getSkillBar().update((HumanEntity)player), 0);
        }
    }

    @EventHandler
    public void onDowngrade(PlayerSkillDowngradeEvent event) {
        if (event.getPlayerData().getSkillBar().isSetup()) {
            Fabled.schedule(() -> Fabled.getData((OfflinePlayer)event.getPlayerData().getPlayer()).getSkillBar().update((HumanEntity)event.getPlayerData().getPlayer()), 1);
        }
    }

    @EventHandler
    public void onAssign(InventoryClickEvent event) {
        if (event.getAction() != InventoryAction.HOTBAR_MOVE_AND_READD || !(event.getInventory().getHolder() instanceof SkillHandler)) {
            return;
        }
        PlayerData data = Fabled.getData((OfflinePlayer)((Player)event.getWhoClicked()));
        if (!data.getSkillBar().isSetup() || data.getSkillBar().isWeaponSlot(event.getHotbarButton())) {
            return;
        }
        SkillHandler handler = (SkillHandler)event.getInventory().getHolder();
        Skill skill = (Skill)handler.get(event.getSlot());
        if (skill != null && skill.canCast()) {
            data.getSkillBar().assign(data.getSkill(skill.getName()), event.getHotbarButton());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onDeath(PlayerDeathEvent event) {
        if (event instanceof Cancellable && ((Cancellable)event).isCancelled()) {
            return;
        }
        if (CitizensHook.isNPC((Entity)event.getEntity()) || !Fabled.getSettings().isWorldEnabled(event.getEntity().getWorld()) || event.getEntity().getWorld().getGameRuleValue("keepInventory").equals("true")) {
            return;
        }
        Player player = event.getEntity();
        PlayerData data = Fabled.getData((OfflinePlayer)player);
        if (data.getSkillBar().isSetup()) {
            player.setMetadata("skill-bar-setup", (MetadataValue)new FixedMetadataValue((Plugin)Fabled.inst(), (Object)true));
            for (int i = 0; i < 9; ++i) {
                if (data.getSkillBar().isWeaponSlot(i)) continue;
                event.getDrops().remove(player.getInventory().getItem(i));
            }
            data.getSkillBar().clear(player);
        }
        event.getDrops().remove(player.getInventory().getItem(this.slot));
        player.getInventory().setItem(this.slot, null);
        ItemStack[] hidden = this.backup.get(player.getUniqueId());
        if (hidden != null) {
            Arrays.stream(hidden).filter(Objects::nonNull).forEach(item -> event.getDrops().add(item));
            this.backup.put(player.getUniqueId(), new ItemStack[9]);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void postDeath(PlayerDeathEvent event) {
        boolean wasSetup;
        if (CitizensHook.isNPC((Entity)event.getEntity()) || event instanceof Cancellable && !((Cancellable)event).isCancelled()) {
            return;
        }
        Player player = event.getEntity();
        boolean bl = wasSetup = player.hasMetadata("skill-bar-setup") && ((MetadataValue)player.getMetadata("skill-bar-setup").get(0)).asBoolean();
        if (!wasSetup) {
            return;
        }
        player.removeMetadata("skill-bar-setup", (Plugin)Fabled.inst());
        PlayerData data = Fabled.getData((OfflinePlayer)player);
        player.getInventory().setItem(this.slot, Fabled.getSettings().getCastItem());
        data.getSkillBar().setup((HumanEntity)player);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onRespawn(PlayerRespawnEvent event) {
        if (!event.getPlayer().getWorld().getGameRuleValue("keepInventory").equals("true")) {
            this.init(event.getPlayer());
        }
    }

    @EventHandler
    public void onDupe(InventoryClickEvent event) {
        if (!Fabled.getSettings().isWorldEnabled(event.getWhoClicked().getWorld())) {
            return;
        }
        if (event.getSlot() == this.slot && event.getSlotType() == InventoryType.SlotType.QUICKBAR || (event.getAction() == InventoryAction.HOTBAR_SWAP || event.getAction() == InventoryAction.HOTBAR_MOVE_AND_READD) && event.getHotbarButton() == this.slot) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onToggle(InventoryClickEvent event) {
        PlayerData data = Fabled.getData((OfflinePlayer)((Player)event.getWhoClicked()));
        PlayerSkillBar skillBar = data.getSkillBar();
        if (!skillBar.isSetup()) {
            return;
        }
        if (!(event.getAction() != InventoryAction.HOTBAR_SWAP && event.getAction() != InventoryAction.HOTBAR_MOVE_AND_READD || skillBar.isWeaponSlot(event.getHotbarButton()) && skillBar.isWeaponSlot(event.getSlot()))) {
            event.setCancelled(true);
            return;
        }
        int slot = event.getSlot();
        if (event.getSlot() < 9 && event.getRawSlot() > VersionManager.getCompat().getTopInventory((InventoryEvent)event).getSize()) {
            if (event.getSlot() == this.slot) {
                event.setCancelled(true);
            } else if (event.getClick() == ClickType.LEFT || event.getClick() == ClickType.SHIFT_LEFT) {
                event.setCancelled(!skillBar.isWeaponSlot(slot));
            } else if (!(event.getClick() != ClickType.RIGHT && event.getClick() != ClickType.SHIFT_RIGHT || skillBar.isWeaponSlot(slot) && (!skillBar.isWeaponSlot(slot) || event.getCurrentItem() != null && event.getCurrentItem().getType() != Material.AIR))) {
                event.setCancelled(true);
                skillBar.toggleSlot(slot);
            } else if (event.getAction().name().startsWith("DROP")) {
                event.setCancelled(!skillBar.isWeaponSlot(slot));
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChangeWorldPre(PlayerChangedWorldEvent event) {
        PlayerData data = Fabled.getData((OfflinePlayer)event.getPlayer());
        boolean enabled = Fabled.getSettings().isWorldEnabled(event.getPlayer().getWorld());
        boolean wasEnabled = Fabled.getSettings().isWorldEnabled(event.getFrom());
        if (data.hasClass() && data.getSkillBar().isSetup() && enabled) {
            this.ignored.add(event.getPlayer().getUniqueId());
        }
        if (!enabled && wasEnabled) {
            this.cleanup(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChangeWorld(PlayerChangedWorldEvent event) {
        boolean enabled = Fabled.getSettings().isWorldEnabled(event.getPlayer().getWorld());
        boolean wasEnabled = Fabled.getSettings().isWorldEnabled(event.getFrom());
        if (enabled && !wasEnabled) {
            this.init(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChangeAccount(PlayerAccountChangeEvent event) {
        if (event.getPreviousAccount().getSkillBar().isSetup()) {
            this.toggle(event.getPreviousAccount().getPlayer());
        }
    }

    @EventHandler
    public void onCast(PlayerItemHeldEvent event) {
        if (!Fabled.getSettings().isWorldEnabled(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getNewSlot() == this.slot) {
            event.setCancelled(true);
            if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                this.toggle(event.getPlayer());
            }
            return;
        }
        PlayerData data = Fabled.getData((OfflinePlayer)event.getPlayer());
        PlayerSkillBar bar = data.getSkillBar();
        if (!bar.isWeaponSlot(event.getNewSlot()) && bar.isSetup()) {
            event.setCancelled(true);
            if (this.ignored.remove(event.getPlayer().getUniqueId())) {
                return;
            }
            bar.apply(event.getNewSlot());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChangeMode(PlayerGameModeChangeEvent event) {
        PlayerData data = Fabled.getData((OfflinePlayer)event.getPlayer());
        if (event.getNewGameMode() == GameMode.CREATIVE && data.getSkillBar().isSetup()) {
            this.toggle(data.getPlayer());
        }
    }

    private void handleClear(Player player) {
        this.backup.put(player.getUniqueId(), new ItemStack[9]);
        PlayerSkillBar skillBar = Fabled.getData((OfflinePlayer)player).getSkillBar();
        if (skillBar.isSetup()) {
            skillBar.update((HumanEntity)player);
        }
        player.getInventory().setItem(this.slot, Fabled.getSettings().getCastItem());
    }
}

