/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.util.DataUT;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.event.KeyPressEvent;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.player.PlayerSkill;
import studio.magemonkey.fabled.listener.FabledListener;
import studio.magemonkey.fabled.listener.MainListener;

public class BindListener
extends FabledListener {
    public static final NamespacedKey SKILLS_KEY = new NamespacedKey((Plugin)Fabled.inst(), "bound_skills");
    private static final Map<Player, Integer> indexes = new HashMap<Player, Integer>();

    @Override
    public void init() {
        MainListener.registerJoin(this::init);
        MainListener.registerClear(this::cleanup);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.init(player);
        }
    }

    @Override
    public void cleanup() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.cleanup(player);
        }
    }

    public void init(Player player) {
        if (!Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            return;
        }
        ItemStack itemStack = BindListener.getHeldItem(player.getInventory());
        if (itemStack == null) {
            return;
        }
        List<PlayerSkill> boundSkills = BindListener.getBoundSkills(itemStack, Fabled.getData((OfflinePlayer)player));
        if (boundSkills.isEmpty()) {
            return;
        }
        boundSkills.get(BindListener.getIndex(player, boundSkills.size())).startPreview();
    }

    public void cleanup(Player player) {
        indexes.remove(player);
        Fabled.getData((OfflinePlayer)player).setOnPreviewStop(null);
    }

    @Nullable
    public static ItemStack getHeldItem(PlayerInventory inventory) {
        ItemStack heldItem = inventory.getItemInMainHand();
        if (heldItem.getItemMeta() == null) {
            heldItem = inventory.getItemInOffHand();
        }
        if (heldItem.getItemMeta() == null) {
            return null;
        }
        return heldItem;
    }

    public static List<String> getBoundSkills(@NotNull ItemStack itemStack) {
        String[] array = (String[])Objects.requireNonNull(itemStack.getItemMeta()).getPersistentDataContainer().get(SKILLS_KEY, DataUT.STRING_ARRAY);
        ArrayList<String> list = new ArrayList<String>();
        if (array != null) {
            Collections.addAll(list, array);
        }
        return list;
    }

    public static void setBoundSkills(@NotNull ItemStack itemStack, @Nullable List<String> boundSkills) {
        ItemMeta meta = Objects.requireNonNull(itemStack.getItemMeta());
        if (boundSkills == null || boundSkills.isEmpty()) {
            meta.getPersistentDataContainer().remove(SKILLS_KEY);
        } else {
            String[] array = new String[boundSkills.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = boundSkills.get(i);
            }
            meta.getPersistentDataContainer().set(SKILLS_KEY, DataUT.STRING_ARRAY, (Object)array);
        }
        itemStack.setItemMeta(meta);
    }

    public static List<PlayerSkill> getBoundSkills(@NotNull ItemStack itemStack, @NotNull PlayerData playerData) {
        List<String> skillNames = BindListener.getBoundSkills(itemStack);
        return skillNames.stream().map(playerData::getSkill).filter(skill -> skill != null && skill.getLevel() > 0).collect(Collectors.toList());
    }

    public static int getIndex(Player player, int boundSkills) {
        return (indexes.getOrDefault(player, 0) % boundSkills + boundSkills) % boundSkills;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInteract(KeyPressEvent event) {
        Player player = event.getPlayer();
        if (!Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            return;
        }
        PlayerData playerData = Fabled.getData((OfflinePlayer)player);
        ItemStack heldItem = BindListener.getHeldItem(player.getInventory());
        if (heldItem == null) {
            return;
        }
        List<PlayerSkill> boundSkills = BindListener.getBoundSkills(heldItem, playerData);
        if (boundSkills.isEmpty()) {
            return;
        }
        int index = BindListener.getIndex(player, boundSkills.size());
        switch (event.getKey()) {
            case LEFT: {
                playerData.cast(boundSkills.get(index));
                break;
            }
            case RIGHT: {
                playerData.setOnPreviewStop(null);
                index = (index + 1) % boundSkills.size();
                indexes.put(player, index);
                boundSkills.get(index).startPreview();
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onItemHeld(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        indexes.remove(player);
        PlayerData playerData = Fabled.getData((OfflinePlayer)player);
        playerData.setOnPreviewStop(null);
        if (!Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            return;
        }
        ItemStack heldItem = player.getInventory().getItem(event.getNewSlot());
        if (heldItem != null && heldItem.getItemMeta() != null) {
            List<PlayerSkill> boundSkills = BindListener.getBoundSkills(heldItem, playerData);
            if (boundSkills.isEmpty()) {
                return;
            }
            boundSkills.get(0).startPreview();
        }
    }
}

