/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.listener;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.DefaultCombatProtection;
import studio.magemonkey.fabled.api.event.PlayerCastSkillEvent;
import studio.magemonkey.fabled.api.event.PlayerExperienceGainEvent;
import studio.magemonkey.fabled.api.player.PlayerClass;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.hook.PluginChecker;
import studio.magemonkey.fabled.hook.WorldGuardHook;
import studio.magemonkey.fabled.listener.FabledListener;
import studio.magemonkey.fabled.listener.ListenerUtil;

public class AddonListener
extends FabledListener {
    private static final Set<UUID> IGNORE_CASTING = new HashSet<UUID>();

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerHit(EntityDamageByEntityEvent event) {
        if (!Fabled.getSettings().isWorldEnabled(event.getEntity().getWorld()) || DefaultCombatProtection.isFakeDamageEvent(event)) {
            return;
        }
        LivingEntity damager = ListenerUtil.getDamager(event);
        if (event.getEntity() instanceof Player && damager instanceof Player) {
            PlayerData attackerData = Fabled.getData((OfflinePlayer)((Player)damager));
            PlayerData defenderData = Fabled.getData((OfflinePlayer)((Player)event.getEntity()));
            for (String group : Fabled.getGroups()) {
                boolean friendly = Fabled.getSettings().getGroupSettings(group).isFriendly();
                PlayerClass attacker = attackerData.getClass(group);
                PlayerClass defender = defenderData.getClass(group);
                if (!friendly || attacker == null || defender == null || attacker.getData().getRoot() != defender.getData().getRoot()) continue;
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onChangeWorld(PlayerChangedWorldEvent e) {
        this.startIgnoring(e.getPlayer());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        this.startIgnoring(e.getPlayer());
    }

    private void startIgnoring(Player player) {
        if (!Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            return;
        }
        UUID uuid = player.getUniqueId();
        IGNORE_CASTING.add(uuid);
        Fabled.schedule(() -> IGNORE_CASTING.remove(uuid), 40);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onSkillUse(PlayerCastSkillEvent e) {
        if (IGNORE_CASTING.contains(e.getPlayer().getUniqueId())) {
            e.setCancelled(true);
        } else if (PluginChecker.isWorldGuardActive() && WorldGuardHook.getRegionIds(e.getPlayer().getLocation()).stream().anyMatch(id -> Fabled.getSettings().areSkillsDisabledForRegion((String)id))) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onExpGain(PlayerExperienceGainEvent e) {
        if (PluginChecker.isWorldGuardActive() && WorldGuardHook.getRegionIds(e.getPlayerData().getPlayer().getLocation()).stream().anyMatch(id -> Fabled.getSettings().isExpDisabledForRegion((String)id))) {
            e.setCancelled(true);
        }
    }
}

