/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.hook;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketListener;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.fabled.Fabled;

public class ProtocolLibHook {
    private final Fabled plugin;
    private final ProtocolManager protocolManager;

    public ProtocolLibHook(Fabled plugin) {
        this.plugin = plugin;
        this.protocolManager = ProtocolLibrary.getProtocolManager();
    }

    public void register(PacketAdapter listener) {
        this.protocolManager.addPacketListener((PacketListener)listener);
    }

    public void unregister() {
        this.protocolManager.removePacketListeners((Plugin)this.plugin);
    }

    public void unregister(PacketAdapter listener) {
        this.protocolManager.removePacketListener((PacketListener)listener);
    }

    public void unregister(Iterable<PacketAdapter> listeners) {
        listeners.forEach(c -> this.unregister((PacketAdapter)c));
    }

    public void broadcastToNearby(Player player, PacketContainer packet) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            double viewDistance;
            double dist;
            if (player.equals((Object)p) || !p.getWorld().equals((Object)player.getWorld()) || !((dist = player.getLocation().distanceSquared(p.getLocation())) < (viewDistance = (double)Bukkit.getViewDistance()) * viewDistance * 16.0)) continue;
            this.protocolManager.sendServerPacket(p, packet);
        }
    }

    @Generated
    public ProtocolManager getProtocolManager() {
        return this.protocolManager;
    }
}

