/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.gui.tool;

import studio.magemonkey.fabled.Fabled;

public enum GUIType {
    CLASS_SELECTION(0, "cs"),
    CLASS_DETAILS(1, "cd"),
    SKILL_TREE(2, "st"),
    ATTRIBUTES(3, "a");

    private int id;
    private String prefix;
    private static final GUIType[] ORDERED;

    private GUIType(int id, String prefix) {
        this.id = id;
        this.prefix = prefix;
    }

    public GUIType next() {
        if (this.cycle(1) == SKILL_TREE && Fabled.getClasses().isEmpty()) {
            return this.cycle(2);
        }
        return this.cycle(1);
    }

    public GUIType prev() {
        if (this.cycle(-1) == SKILL_TREE && Fabled.getClasses().isEmpty()) {
            return this.cycle(-2);
        }
        return this.cycle(-1);
    }

    private GUIType cycle(int direction) {
        GUIType type = ORDERED[(this.id + ORDERED.length + direction) % ORDERED.length];
        if (type == ATTRIBUTES && !Fabled.getSettings().isAttributesEnabled()) {
            return ORDERED[(this.id + ORDERED.length + 2 * direction) % ORDERED.length];
        }
        return type;
    }

    public String getPrefix() {
        return this.prefix;
    }

    static {
        ORDERED = new GUIType[]{CLASS_SELECTION, CLASS_DETAILS, SKILL_TREE, ATTRIBUTES};
    }
}

