/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.trigger;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.dynamic.trigger.Trigger;

public class StripLogTrigger
implements Trigger<PlayerInteractEvent> {
    @Override
    public String getKey() {
        return "STRIP_LOG";
    }

    @Override
    public Class<PlayerInteractEvent> getEvent() {
        return PlayerInteractEvent.class;
    }

    @Override
    public boolean shouldTrigger(PlayerInteractEvent event, int level, Settings settings) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return false;
        }
        Block block = event.getClickedBlock();
        ItemStack item = event.getItem();
        if (block == null || item == null || item.getType() == Material.AIR) {
            return false;
        }
        if (!item.getType().toString().endsWith("_AXE")) {
            return false;
        }
        List<String> types = settings.getStringList("material");
        Material blockType = block.getType();
        String blockName = blockType.name();
        boolean matchesList = types.isEmpty() || types.contains("Any") || types.stream().anyMatch(mat -> blockName.equalsIgnoreCase(mat.trim().replace(' ', '_').toUpperCase()));
        boolean isStrippableBlock = StripLogTrigger.isStrippable(blockType);
        return matchesList && isStrippableBlock;
    }

    @Override
    public void setValues(PlayerInteractEvent event, CastData data) {
        data.put("api-block-type", event.getClickedBlock().getType().name());
        data.put("api-block-loc", event.getClickedBlock().getLocation());
    }

    @Override
    public LivingEntity getCaster(PlayerInteractEvent event) {
        return event.getPlayer();
    }

    @Override
    public LivingEntity getTarget(PlayerInteractEvent event, Settings settings) {
        return event.getPlayer();
    }

    public static boolean isStrippable(Material material) {
        String name = material.name();
        return !name.contains("STRIPPED") && (name.contains("LOG") || name.contains("WOOD") || name.contains("STEM") || name.contains("HYPHAE"));
    }
}

