/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.trigger;

import java.util.List;
import java.util.Objects;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.projectiles.ProjectileSource;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.api.particle.target.EntityTarget;
import studio.magemonkey.fabled.dynamic.TempEntity;
import studio.magemonkey.fabled.dynamic.trigger.Trigger;

public class ProjectileHitTrigger
implements Trigger<ProjectileHitEvent> {
    @Override
    public String getKey() {
        return "PROJECTILE_HIT";
    }

    @Override
    public Class<ProjectileHitEvent> getEvent() {
        return ProjectileHitEvent.class;
    }

    @Override
    public boolean shouldTrigger(ProjectileHitEvent event, int level, Settings settings) {
        Projectile proj = event.getEntity();
        List<String> projectiles = settings.getStringList("projectile");
        String type = this.translateType(settings.getString("type", "both"));
        boolean hitEntity = Objects.nonNull(event.getHitEntity());
        boolean correctProjectile = projectiles.isEmpty() || projectiles.contains("Any") || projectiles.stream().anyMatch(projectile -> proj.getType().name().equalsIgnoreCase((String)projectile));
        boolean correctType = type.equalsIgnoreCase("both") || type.equalsIgnoreCase("entity") == hitEntity;
        return correctProjectile && correctType;
    }

    private String translateType(String typeInput) {
        return switch (typeInput.toLowerCase()) {
            case "both" -> "both";
            case "entity" -> "entity";
            default -> "both";
        };
    }

    @Override
    public void setValues(ProjectileHitEvent event, CastData data) {
    }

    @Override
    public LivingEntity getCaster(ProjectileHitEvent event) {
        ProjectileSource shooter = event.getEntity().getShooter();
        return shooter instanceof LivingEntity ? (LivingEntity)shooter : null;
    }

    @Override
    public LivingEntity getTarget(ProjectileHitEvent event, Settings settings) {
        TempEntity projectile = new TempEntity(new EntityTarget((Entity)event.getEntity()));
        boolean targetCaster = settings.getBool("target", false);
        Entity hit = event.getHitEntity();
        if (targetCaster) {
            return (LivingEntity)event.getEntity().getShooter();
        }
        if (Objects.nonNull(hit)) {
            return hit instanceof LivingEntity ? (LivingEntity)hit : new TempEntity(hit.getLocation());
        }
        return projectile;
    }
}

