/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.trigger;

import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.api.event.PhysicalDamageEvent;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.trigger.Trigger;

public abstract class PhysicalTrigger
implements Trigger<PhysicalDamageEvent> {
    @Override
    public Class<PhysicalDamageEvent> getEvent() {
        return PhysicalDamageEvent.class;
    }

    @Override
    public boolean shouldTrigger(PhysicalDamageEvent event, int level, Settings settings) {
        String type = settings.getString("type", "both");
        double min = settings.getDouble("dmg-min");
        double max = settings.getDouble("dmg-max");
        boolean projectile = event.isProjectile();
        return event.getDamage() >= min && event.getDamage() <= max && (type.equalsIgnoreCase("both") || type.equalsIgnoreCase("projectile") == projectile);
    }

    @Override
    public void postProcess(PhysicalDamageEvent event, DynamicSkill skill) {
        double damage = skill.applyImmediateBuff(event.getDamage());
        event.setDamage(damage);
    }

    boolean isUsingTarget(Settings settings) {
        return settings.getString("target", "true").equalsIgnoreCase("false");
    }
}

