/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.trigger;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.dynamic.trigger.Trigger;

public class LaunchTrigger
implements Trigger<ProjectileLaunchEvent> {
    @Override
    public String getKey() {
        return "LAUNCH";
    }

    @Override
    public Class<ProjectileLaunchEvent> getEvent() {
        return ProjectileLaunchEvent.class;
    }

    @Override
    public boolean shouldTrigger(ProjectileLaunchEvent event, int level, Settings settings) {
        List<String> types = settings.getStringList("types");
        if (types.isEmpty()) {
            types = new ArrayList<String>(List.of(settings.getString("type", "Any")));
        }
        return types.contains("Any") || types.stream().anyMatch(proj -> event.getEntity().getType().name().equalsIgnoreCase(proj.replace(' ', '_')));
    }

    @Override
    public void setValues(ProjectileLaunchEvent event, CastData data) {
        data.put("api-velocity", event.getEntity().getVelocity().length());
    }

    @Override
    public LivingEntity getCaster(ProjectileLaunchEvent event) {
        if (event.getEntity().getShooter() instanceof LivingEntity) {
            return (LivingEntity)event.getEntity().getShooter();
        }
        return null;
    }

    @Override
    public LivingEntity getTarget(ProjectileLaunchEvent event, Settings settings) {
        return this.getCaster(event);
    }
}

