/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.trigger;

import org.bukkit.entity.LivingEntity;
import org.bukkit.event.player.PlayerExpChangeEvent;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.dynamic.trigger.Trigger;

public class ExperienceTrigger
implements Trigger<PlayerExpChangeEvent> {
    @Override
    public String getKey() {
        return "EXPERIENCE";
    }

    @Override
    public Class<PlayerExpChangeEvent> getEvent() {
        return PlayerExpChangeEvent.class;
    }

    @Override
    public boolean shouldTrigger(PlayerExpChangeEvent event, int level, Settings settings) {
        double minExperience = settings.getDouble("min-experience", 0.0);
        return (double)event.getAmount() >= minExperience;
    }

    @Override
    public void setValues(PlayerExpChangeEvent event, CastData data) {
        int experience = event.getAmount();
        data.put("api-experience", experience);
    }

    @Override
    public LivingEntity getCaster(PlayerExpChangeEvent event) {
        return event.getPlayer();
    }

    @Override
    public LivingEntity getTarget(PlayerExpChangeEvent event, Settings settings) {
        return event.getPlayer();
    }
}

