/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.trigger;

import java.util.List;
import java.util.Locale;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.dynamic.trigger.Trigger;

public class EntityTargetTrigger
implements Trigger<EntityTargetLivingEntityEvent> {
    @Override
    public String getKey() {
        return "ENTITY_TARGET";
    }

    @Override
    public Class<EntityTargetLivingEntityEvent> getEvent() {
        return EntityTargetLivingEntityEvent.class;
    }

    @Override
    public boolean shouldTrigger(EntityTargetLivingEntityEvent event, int level, Settings settings) {
        if (!(event.getEntity() instanceof LivingEntity) || event.getTarget() == null) {
            return false;
        }
        List<String> types = settings.getStringList("types");
        boolean inverted = settings.getBool("blacklist", false);
        if (!types.isEmpty() && !types.get(0).equalsIgnoreCase("Any")) {
            for (String type : types) {
                EntityType entityType = EntityType.valueOf((String)type.toUpperCase(Locale.US));
                if (event.getEntityType() != entityType) continue;
                return !inverted;
            }
            return inverted;
        }
        return !inverted;
    }

    @Override
    public void setValues(EntityTargetLivingEntityEvent event, CastData data) {
    }

    @Override
    public LivingEntity getCaster(EntityTargetLivingEntityEvent event) {
        return event.getTarget();
    }

    @Override
    public LivingEntity getTarget(EntityTargetLivingEntityEvent event, Settings settings) {
        boolean targetCaster = settings.getBool("target", true);
        return targetCaster ? event.getTarget() : (LivingEntity)event.getEntity();
    }
}

