/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.target;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import studio.magemonkey.fabled.dynamic.TempEntity;
import studio.magemonkey.fabled.dynamic.target.TargetComponent;

public class LocationTarget
extends TargetComponent {
    private static final String RANGE = "range";
    private static final String ENTITIES = "entities";
    private static final String FLUIDS = "fluids";
    private static final String PASSABLE = "passable";
    private static final String CENTER = "center";
    private static final String GROUND = "ground";

    @Override
    public List<LivingEntity> getTargets(LivingEntity caster, int level, List<LivingEntity> targets) {
        double range = this.parseValues(caster, RANGE, level, 5.0);
        boolean entities = this.settings.getBool(ENTITIES, true);
        boolean fluids = this.settings.getBool(FLUIDS, false);
        boolean passable = this.settings.has(PASSABLE) ? this.settings.getBool(PASSABLE) : this.settings.getBool(GROUND, true);
        boolean center = this.settings.getBool(CENTER, false);
        return this.determineTargets(caster, level, targets, t -> this.getTargetLoc(caster, (LivingEntity)t, range, entities, fluids, passable, center));
    }

    private List<LivingEntity> getTargetLoc(LivingEntity caster, LivingEntity t, double range, boolean entities, boolean fluids, boolean passable, boolean center) {
        Location location;
        RayTraceResult rayTrace;
        FluidCollisionMode fluidMode;
        World world = t.getWorld();
        Location startLocation = t.getEyeLocation();
        Vector direction = startLocation.getDirection();
        FluidCollisionMode fluidCollisionMode = fluidMode = fluids ? FluidCollisionMode.ALWAYS : FluidCollisionMode.NEVER;
        RayTraceResult rayTraceResult = entities ? world.rayTrace(startLocation, direction, range, fluidMode, !passable, 0.0, entity -> entity != caster) : (rayTrace = world.rayTraceBlocks(startLocation, direction, range, fluidMode, !passable));
        if (rayTrace == null) {
            location = startLocation.add(direction.multiply(range));
        } else {
            Block hitBlock = rayTrace.getHitBlock();
            location = center && hitBlock != null ? hitBlock.getLocation() : rayTrace.getHitPosition().toLocation(world);
        }
        location.setDirection(direction);
        if (center) {
            this.center(location);
        }
        return ImmutableList.of((Object)new TempEntity(location));
    }

    private void center(Location location) {
        location.setX((double)location.getBlockX() + 0.5);
        location.setY((double)location.getBlockY() + 0.5);
        location.setZ((double)location.getBlockZ() + 0.5);
    }

    @Override
    public String getKey() {
        return "location";
    }
}

