/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.target;

import java.util.List;
import java.util.function.Supplier;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.particle.ParticleSettings;
import studio.magemonkey.fabled.api.target.TargetHelper;
import studio.magemonkey.fabled.dynamic.target.TargetComponent;

public class ConeTarget
extends TargetComponent {
    private static final String ANGLE = "angle";
    private static final String RANGE = "range";
    private static final String ROTATION = "rotation";
    private static final String RESET_Y = "reset-y";

    @Override
    public void playPreview(List<Runnable> onPreviewStop, final Player caster, int level, final Supplier<List<LivingEntity>> targetSupplier) {
        double density;
        ParticleSettings particleSettings;
        super.playPreview(onPreviewStop, caster, level, targetSupplier);
        final boolean resetY = this.settings.getBool(RESET_Y, true);
        final double angle = this.parseValues((LivingEntity)caster, ANGLE, level, 90.0) * Math.PI / 360.0;
        final double range = this.parseValues((LivingEntity)caster, RANGE, level, 5.0);
        final double rotation = -this.parseValues((LivingEntity)caster, ROTATION, level, 0.0) * Math.PI / 180.0;
        if (this.preview.getBool("triangle", false)) {
            particleSettings = new ParticleSettings(this.preview, "triangle-");
            density = this.preview.getDouble("triangle-density", 1.0);
            final double rStep = 1.0 / range / density;
            BukkitTask task = new BukkitRunnable(){

                public void run() {
                    for (LivingEntity target : (List)targetSupplier.get()) {
                        Location origin = target.getEyeLocation().clone();
                        if (resetY) {
                            origin.setPitch(0.0f);
                        }
                        if (rotation != 0.0) {
                            origin.setYaw((float)((double)origin.getYaw() + rotation));
                        }
                        Vector direction = origin.getDirection();
                        Location altDirection = origin.clone();
                        altDirection.setPitch((altDirection.getPitch() + 135.0f) % 180.0f - 90.0f);
                        Vector perpendicular = altDirection.getDirection().crossProduct(direction);
                        Vector directionStep = direction.clone().multiply(rStep);
                        double startDistance = ConeTarget.this.preview.getDouble("triangle-start-distance", 2.0);
                        origin.add(direction.clone().multiply(startDistance));
                        for (double rLocation = startDistance; rLocation <= range; rLocation += rStep) {
                            double radius = rLocation * Math.tan(angle);
                            Vector vector = perpendicular.clone().multiply(radius);
                            particleSettings.instance(caster, origin.getX() + vector.getX(), origin.getY() + vector.getY(), origin.getZ() + vector.getZ());
                            particleSettings.instance(caster, origin.getX() - vector.getX(), origin.getY() - vector.getY(), origin.getZ() - vector.getZ());
                            origin.add(directionStep);
                        }
                    }
                }
            }.runTaskTimer((Plugin)Fabled.inst(), 0L, (long)Math.max(1, this.preview.getInt("triangle-period", 5)));
            onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        }
        if (this.preview.getBool("cone", false)) {
            particleSettings = new ParticleSettings(this.preview, "cone-");
            density = this.preview.getDouble("cone-density", 1.0);
            BukkitTask task = new BukkitRunnable(){

                public void run() {
                    double rStep = 1.0 / range / density;
                    for (LivingEntity target : (List)targetSupplier.get()) {
                        Location origin = target.getEyeLocation().clone();
                        if (resetY) {
                            origin.setPitch(0.0f);
                        }
                        if (rotation != 0.0) {
                            origin.setYaw((float)((double)origin.getYaw() + rotation));
                        }
                        Vector direction = origin.getDirection();
                        Location altDirection = origin.clone();
                        altDirection.setPitch((altDirection.getPitch() + 135.0f) % 180.0f - 90.0f);
                        Vector perpendicular = altDirection.getDirection().crossProduct(direction);
                        Vector directionStep = direction.clone().multiply(rStep);
                        double startDistance = ConeTarget.this.preview.getDouble("cone-start-distance", 2.0);
                        origin.add(direction.clone().multiply(startDistance));
                        for (double rLocation = startDistance; rLocation <= range; rLocation += rStep) {
                            double radius = rLocation * Math.tan(angle);
                            Vector radiusVec = perpendicular.clone().multiply(radius);
                            double angleStep = 1.0 / radius / density;
                            for (double totalAngle = 0.0; totalAngle <= 3.241592653589793; totalAngle += angleStep) {
                                Vector vector = radiusVec.clone().rotateAroundNonUnitAxis(direction, totalAngle);
                                particleSettings.instance(caster, origin.getX() + vector.getX(), origin.getY() + vector.getY(), origin.getZ() + vector.getZ());
                                particleSettings.instance(caster, origin.getX() - vector.getX(), origin.getY() - vector.getY(), origin.getZ() - vector.getZ());
                            }
                            origin.add(directionStep);
                        }
                    }
                }
            }.runTaskTimer((Plugin)Fabled.inst(), 0L, (long)Math.max(1, this.preview.getInt("cone-period", 5)));
            onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        }
    }

    @Override
    public List<LivingEntity> getTargets(LivingEntity caster, int level, List<LivingEntity> targets) {
        double range = this.parseValues(caster, RANGE, level, 3.0);
        double angle = this.parseValues(caster, ANGLE, level, 90.0);
        double rotation = this.parseValues(caster, ROTATION, level, 0.0);
        boolean resetY = this.settings.getBool(RESET_Y, true);
        return this.determineTargets(caster, level, targets, t -> TargetHelper.getConeTargets(t, angle, range, rotation, resetY));
    }

    @Override
    public String getKey() {
        return "cone";
    }
}

