/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic.value;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;
import studio.magemonkey.fabled.dynamic.target.RememberTarget;

public class ValueRotationMechanic
extends MechanicComponent {
    private static final String KEY = "key";
    private static final String SOURCE = "source";
    private static final String SAVE = "save";

    @Override
    public String getKey() {
        return "value rotation";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        LivingEntity target;
        if (targets.isEmpty()) {
            return false;
        }
        List<LivingEntity> potentialSources = RememberTarget.remember(caster, this.settings.getString(SOURCE, "_none"));
        if (potentialSources.isEmpty()) {
            potentialSources = List.of(caster);
        }
        String key = this.settings.getString(KEY);
        LivingEntity source = potentialSources.get(0);
        if (source.equals((Object)(target = targets.get(0)))) {
            return false;
        }
        Location targetEyeLoc = target.getEyeLocation();
        Vector targetDir = target.getLocation().getDirection();
        Vector sourceVec = source.getLocation().subtract(targetEyeLoc).toVector();
        double dot = targetDir.dot(sourceVec);
        double magnitude = sourceVec.length();
        double angle = Math.toDegrees(Math.acos(dot / magnitude));
        CastData data = DynamicSkill.getCastData(caster);
        data.put(key, angle);
        if (this.settings.getBool(SAVE, false)) {
            Fabled.getData((OfflinePlayer)caster).setPersistentData(key, data.getRaw(key));
        }
        return true;
    }
}

