/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic.value;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class ValueCopyMechanic
extends MechanicComponent {
    private static final String KEY = "key";
    private static final String TARGET = "destination";
    private static final String TO_TARGET = "to-target";
    private static final String SAVE = "save";

    @Override
    public String getKey() {
        return "value copy";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.size() == 0 || !this.settings.has(KEY)) {
            return false;
        }
        String key = this.settings.getString(KEY);
        String destination = this.settings.getString(TARGET, key);
        boolean toTarget = this.settings.getString(TO_TARGET, "true").equalsIgnoreCase("true");
        if (toTarget) {
            targets.forEach(target -> this.apply(caster, (LivingEntity)target, key, destination));
        } else {
            this.apply(targets.get(0), caster, key, destination);
        }
        if (this.settings.getBool(SAVE, false)) {
            Fabled.getData((OfflinePlayer)caster).setPersistentData(key, DynamicSkill.getCastData(caster).getRaw(key));
        }
        return true;
    }

    private boolean apply(LivingEntity from, LivingEntity to, String key, String destination) {
        Object value = DynamicSkill.getCastData(from).getRaw(key);
        if (value == null) {
            return false;
        }
        DynamicSkill.getCastData(to).put(destination, value);
        return true;
    }
}

