/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic.particle;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.api.particle.ParticleHelper;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class ParticleMechanic
extends MechanicComponent {
    private static final Vector UP = new Vector(0, 1, 0);
    private static final String FORWARD = "forward";
    private static final String UPWARD = "upward";
    private static final String RIGHT = "right";

    @Override
    public String getKey() {
        return "particle";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.size() == 0) {
            return false;
        }
        double forward = this.settings.getDouble(FORWARD, 0.0);
        double upward = this.settings.getDouble(UPWARD, 0.0);
        double right = this.settings.getDouble(RIGHT, 0.0);
        Settings copy = new Settings(this.settings);
        copy.set("particles", this.parseValues(caster, "particles", level, 1.0), 0.0);
        copy.set("radius", this.parseValues(caster, "radius", level, 0.0), 0.0);
        copy.set("level", level);
        for (LivingEntity target : targets) {
            Location loc = target.getLocation();
            Vector dir = loc.getDirection().setY(0).normalize();
            Vector side = dir.clone().crossProduct(UP);
            loc.add(dir.multiply(forward)).add(0.0, upward, 0.0).add(side.multiply(right));
            ParticleHelper.play(loc, copy);
        }
        return targets.size() > 0;
    }
}

