/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic.armorstand;

import java.util.Arrays;
import java.util.List;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.EulerAngle;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class ArmorStandPoseMechanic
extends MechanicComponent {
    private static final String HEAD = "head";
    private static final String BODY = "body";
    private static final String LEFT_ARM = "left-arm";
    private static final String RIGHT_ARM = "right-arm";
    private static final String LEFT_LEG = "left-leg";
    private static final String RIGHT_LEG = "right-leg";

    private static EulerAngle eulerAngle(String string) {
        Double[] doubles;
        if (string.equals("")) {
            return null;
        }
        try {
            doubles = (Double[])Arrays.stream(string.split(",", 3)).map(Double::valueOf).toArray(Double[]::new);
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (doubles.length != 3) {
            return null;
        }
        return new EulerAngle(doubles[0].doubleValue(), doubles[1].doubleValue(), doubles[2].doubleValue());
    }

    @Override
    public String getKey() {
        return "armor stand pose";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        EulerAngle head = ArmorStandPoseMechanic.eulerAngle(this.settings.getString(HEAD, ""));
        EulerAngle body = ArmorStandPoseMechanic.eulerAngle(this.settings.getString(BODY, ""));
        EulerAngle leftArm = ArmorStandPoseMechanic.eulerAngle(this.settings.getString(LEFT_ARM, ""));
        EulerAngle rightArm = ArmorStandPoseMechanic.eulerAngle(this.settings.getString(RIGHT_ARM, ""));
        EulerAngle leftLeg = ArmorStandPoseMechanic.eulerAngle(this.settings.getString(LEFT_LEG, ""));
        EulerAngle rightLeg = ArmorStandPoseMechanic.eulerAngle(this.settings.getString(RIGHT_LEG, ""));
        for (LivingEntity target : targets) {
            if (!(target instanceof ArmorStand)) continue;
            ArmorStand armorStand = (ArmorStand)target;
            if (head != null) {
                armorStand.setHeadPose(head);
            }
            if (body != null) {
                armorStand.setBodyPose(body);
            }
            if (leftArm != null) {
                armorStand.setLeftArmPose(leftArm);
            }
            if (rightArm != null) {
                armorStand.setRightArmPose(rightArm);
            }
            if (leftLeg != null) {
                armorStand.setLeftLegPose(leftLeg);
            }
            if (rightLeg == null) continue;
            armorStand.setRightLegPose(rightLeg);
        }
        return targets.size() > 0;
    }
}

