/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.skills.Skill;
import studio.magemonkey.fabled.api.skills.SkillShot;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class SkillCastMechanic
extends MechanicComponent {
    @Override
    public String getKey() {
        return "skill cast";
    }

    private static void cast(LivingEntity caster, String sk, int lv, boolean force) {
        Skill skill;
        if (sk == null || sk.isBlank()) {
            return;
        }
        if (caster instanceof Player) {
            PlayerData data = Fabled.getData((OfflinePlayer)((Player)caster));
            if (lv <= 0) {
                int n = lv = data.hasSkill(sk) && data.getSkill(sk).getLevel() > 0 ? data.getSkill(sk).getLevel() : 1;
            }
        }
        if ((skill = Fabled.getSkill(sk)) == null) {
            Fabled.inst().getLogger().warning("Attempted to cast skill " + sk + " but it does not exist.");
            return;
        }
        ((SkillShot)((Object)skill)).cast(caster, lv, force);
    }

    private static int parseInt(String input) {
        try {
            return Integer.parseInt(input);
        }
        catch (NullPointerException | NumberFormatException e) {
            return -1;
        }
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.isEmpty()) {
            return false;
        }
        String mode = this.settings.getString("mode", "first").toLowerCase();
        boolean force_cast = this.settings.getBool("force", false);
        List<String> skills = this.settings.getStringList("skills");
        targets.forEach(target -> {
            ArrayList handle = new ArrayList();
            skills.forEach(s -> {
                String[] split = s.split(":", 2);
                handle.add(new AbstractMap.SimpleEntry<String, Integer>(split[0], SkillCastMechanic.parseInt(split.length > 1 ? split[1] : null)));
            });
            List filtered = handle.stream().filter(e -> Fabled.getSkill((String)e.getKey()) != null && Fabled.getSkill((String)e.getKey()) instanceof SkillShot && (force_cast || !(target instanceof Player) || Fabled.getData((OfflinePlayer)((Player)target)).hasSkill((String)e.getKey()) && Fabled.getData((OfflinePlayer)((Player)target)).getSkill((String)e.getKey()).getLevel() > 0)).collect(Collectors.toList());
            if (filtered.isEmpty()) {
                return;
            }
            switch (mode) {
                case "first": {
                    SkillCastMechanic.cast(target, (String)((Map.Entry)filtered.get(0)).getKey(), (Integer)((Map.Entry)filtered.get(0)).getValue(), force_cast);
                    break;
                }
                case "all": {
                    handle.forEach(entry -> SkillCastMechanic.cast(target, (String)entry.getKey(), (Integer)entry.getValue(), force_cast));
                    break;
                }
                case "random": {
                    int i = Fabled.RANDOM.nextInt(filtered.size());
                    SkillCastMechanic.cast(target, (String)((Map.Entry)filtered.get(i)).getKey(), (Integer)((Map.Entry)filtered.get(i)).getValue(), force_cast);
                }
            }
        });
        return true;
    }
}

