/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.metadata.Metadatable;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import studio.magemonkey.codex.legacy.utils.Utils;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.api.particle.EffectPlayer;
import studio.magemonkey.fabled.api.particle.ParticleHelper;
import studio.magemonkey.fabled.api.particle.ParticleSettings;
import studio.magemonkey.fabled.api.particle.target.EntityTarget;
import studio.magemonkey.fabled.api.projectile.CustomProjectile;
import studio.magemonkey.fabled.api.projectile.ParticleProjectile;
import studio.magemonkey.fabled.api.projectile.ProjectileCallback;
import studio.magemonkey.fabled.api.target.TargetHelper;
import studio.magemonkey.fabled.api.util.Nearby;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.TempEntity;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;
import studio.magemonkey.fabled.task.RemoveEntitiesTask;
import studio.magemonkey.fabled.task.RepeatingEntityTask;
import studio.magemonkey.fabled.util.VectorUtil;

public class PotionProjectileMechanic
extends MechanicComponent {
    private static final Vector UP = new Vector(0, 1, 0);
    private static final String FLAMING = "flaming";
    private static final String VELOCITY = "velocity";
    private static final String LIFESPAN = "lifespan";
    private static final String SPREAD = "spread";
    private static final String AMOUNT = "amount";
    private static final String ANGLE = "angle";
    private static final String HEIGHT = "height";
    private static final String RAIN_RADIUS = "rain-radius";
    private static final String FORWARD = "forward";
    private static final String UPWARD = "upward";
    private static final String RIGHT = "right";
    private static final String USE_EFFECT = "use-effect";
    private static final String EFFECT_KEY = "effect-key";
    public static final String HOMING = "homing";
    public static final String HOMING_TARGET = "target";
    public static final String HOMING_DIST = "homing-distance";
    public static final String REMEMBER = "remember-key";
    public static final String CORRECTION = "correction";
    public static final String WALL = "wall";
    public static final String DISTANCE = "distance";
    private static final String ALLY = "group";
    private static final String LINGER = "linger";
    private static final String COLOR = "color";
    public static final String DURATION = "duration";
    public static final String WAIT_TIME = "wait-time";
    public static final String REAPPLY_DELAY = "reapplication-delay";
    public static final String DURATION_ON_USE = "duration-on-use";
    public static final String RADIUS = "cloud-radius";
    public static final String RADIUS_ON_USE = "radius-on-use";
    public static final String RADIUS_PER_TICK = "radius-per-tick";
    public static final String CLOUD_PREFIX = "cloud-";
    private static final NamespacedKey namespaceKey = new NamespacedKey(Objects.requireNonNull(Bukkit.getPluginManager().getPlugin("Fabled")), "proj_start_location");

    @Override
    public String getKey() {
        return "potion projectile";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        int amount = (int)this.parseValues(caster, AMOUNT, level, 1.0);
        double speed = this.parseValues(caster, VELOCITY, level, 2.0);
        boolean flaming = this.settings.getString(FLAMING, "false").equalsIgnoreCase("true");
        String spread = this.settings.getString(SPREAD, "cone").toLowerCase();
        final ArrayList<ThrownPotion> projectiles = new ArrayList<ThrownPotion>();
        for (LivingEntity target : targets) {
            Location location = VectorUtil.getOffsetLocation(target, this.parseValues(caster, FORWARD, level, 0.0), this.parseValues(caster, RIGHT, level, 0.0), this.parseValues(caster, UPWARD, level, 0.0));
            if (spread.equals("rain")) {
                Vector vector = new Vector(0.0, speed, 0.0);
                for (Location loc : CustomProjectile.calcRain(location, this.parseValues(caster, RAIN_RADIUS, level, 2.0), this.parseValues(caster, HEIGHT, level, 8.0), amount)) {
                    ThrownPotion p = (ThrownPotion)caster.launchProjectile(ThrownPotion.class);
                    p.teleport(loc);
                    p.setVelocity(vector);
                    p.getPersistentDataContainer().set(namespaceKey, PersistentDataType.STRING, (Object)Utils.locToString((Location)loc));
                    projectiles.add(p);
                }
                continue;
            }
            Vector vector = location.getDirection();
            if (spread.equals("horizontal cone")) {
                vector.setY(0);
                vector.normalize();
            }
            List<Vector> list = CustomProjectile.calcSpread(vector, this.parseValues(caster, ANGLE, level, 30.0), amount);
            for (Vector d : list) {
                ThrownPotion p = (ThrownPotion)caster.launchProjectile(ThrownPotion.class);
                p.teleport(location);
                p.getPersistentDataContainer().set(namespaceKey, PersistentDataType.STRING, (Object)Utils.locToString((Location)location));
                p.setVelocity(d.multiply(speed));
                projectiles.add(p);
            }
        }
        ItemStack itemStack = new ItemStack(this.settings.getString(LINGER, "false").equalsIgnoreCase("true") ? Material.LINGERING_POTION : Material.SPLASH_POTION);
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            potionMeta.setColor(Color.fromRGB((int)Integer.parseInt(this.settings.getString(COLOR, "#ff0000").substring(1), 16)));
            try {
                potionMeta.setBasePotionType(PotionType.INVISIBILITY);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                potionMeta.setBasePotionData(new PotionData(PotionType.INVISIBILITY));
            }
            itemStack.setItemMeta(meta);
        }
        for (ThrownPotion thrownPotion : projectiles) {
            thrownPotion.setItem(itemStack);
            if (flaming) {
                thrownPotion.setFireTicks(Integer.MAX_VALUE);
            }
            Fabled.setMeta((Metadatable)thrownPotion, "potionProjectile", this);
            Fabled.setMeta((Metadatable)thrownPotion, "skill_level", level);
            Fabled.setMeta((Metadatable)thrownPotion, "caster", caster);
        }
        if (this.settings.getBool(USE_EFFECT, false)) {
            EffectPlayer player = new EffectPlayer(this.settings);
            for (Projectile projectile : projectiles) {
                player.start(new EntityTarget((Entity)projectile), this.settings.getString(EFFECT_KEY, this.skill.getName()), Integer.MAX_VALUE, level, true);
            }
        }
        if (this.settings.getBool(HOMING, false)) {
            void var14_25;
            String target = this.settings.getString(HOMING_TARGET, "nearest");
            if (target.equalsIgnoreCase("remember target")) {
                Function<Projectile, LivingEntity> function = proj -> {
                    Object data = Objects.requireNonNull(DynamicSkill.getCastData((LivingEntity)proj.getShooter())).getRaw(this.settings.getString(REMEMBER, HOMING_TARGET));
                    if (data == null) {
                        return null;
                    }
                    try {
                        return ((List)data).stream().filter(tar -> this.settings.getBool(WALL, false) || !TargetHelper.isObstructed(proj.getLocation(), tar.getEyeLocation())).min(Comparator.comparingDouble(o -> o.getLocation().distanceSquared(proj.getLocation()))).orElse(null);
                    }
                    catch (ClassCastException e) {
                        return null;
                    }
                };
            } else {
                Function<Projectile, LivingEntity> function = proj -> Nearby.getLivingNearby(proj.getLocation(), this.settings.getAttr(HOMING_DIST, 0, 20.0)).stream().filter(tar -> {
                    if (tar == proj.getShooter()) {
                        return false;
                    }
                    return Fabled.getSettings().isValidTarget((LivingEntity)tar);
                }).filter(tar -> this.settings.getBool(WALL, false) || !TargetHelper.isObstructed(proj.getLocation(), tar.getEyeLocation())).min(Comparator.comparingDouble(o -> o.getLocation().distanceSquared(proj.getLocation()))).orElse(null);
            }
            double d = this.settings.getAttr(CORRECTION, 0, 0.2);
            new RepeatingEntityTask<ThrownPotion>(projectiles, arg_0 -> PotionProjectileMechanic.lambda$execute$7((Function)var14_25, speed, d, arg_0));
        }
        int distance = (int)this.parseValues(caster, DISTANCE, level, 50.0);
        new RepeatingEntityTask<ThrownPotion>(projectiles, proj -> {
            ParticleHelper.play(proj.getLocation(), this.settings);
            Location startLocation = Utils.stringToLoc((String)Objects.requireNonNull((String)proj.getPersistentDataContainer().get(namespaceKey, PersistentDataType.STRING)));
            if (startLocation != null && proj.getLocation().distance(startLocation) > (double)(distance * distance)) {
                if (proj.isValid()) {
                    proj.remove();
                }
                if (this.settings.getBool("on-expire", false)) {
                    this.callback(proj, null);
                }
            }
        });
        new RemoveEntitiesTask(projectiles, (int)this.parseValues(caster, LIFESPAN, level, 9999.0) * 20){

            @Override
            public void run() {
                super.run();
                if (PotionProjectileMechanic.this.settings.getBool("on-expire", false)) {
                    for (Projectile projectile1 : projectiles) {
                        PotionProjectileMechanic.this.callback((Entity)projectile1, null);
                    }
                }
            }
        };
        return !targets.isEmpty();
    }

    public void callback(Entity entity, Collection<LivingEntity> hit) {
        ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>(hit);
        String group = this.settings.getString(ALLY, "enemy").toLowerCase();
        boolean both = group.equals("both");
        boolean ally = group.equals("ally");
        LivingEntity caster = (LivingEntity)Fabled.getMeta((Metadatable)entity, "caster");
        int level = Fabled.getMetaInt((Metadatable)entity, "skill_level");
        Location loc = entity.getLocation();
        for (int i = 0; i < targets.size(); ++i) {
            if (both || Fabled.getSettings().canAttack(caster, (LivingEntity)targets.get(i)) != ally) continue;
            targets.remove(i);
            --i;
        }
        if (targets.isEmpty()) {
            TempEntity locTarget = new TempEntity(loc);
            targets.add(locTarget);
        }
        this.executeChildren(caster, level, targets, this.skill.isForced(caster));
    }

    @Override
    public void playPreview(List<Runnable> onPreviewStop, final Player caster, final int level, final Supplier<List<LivingEntity>> targetSupplier) {
        final ArrayList targets = new ArrayList();
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                targets.clear();
                int amount = (int)PotionProjectileMechanic.this.parseValues((LivingEntity)caster, PotionProjectileMechanic.AMOUNT, level, 1.0);
                String spread = PotionProjectileMechanic.this.settings.getString(PotionProjectileMechanic.SPREAD, "cone").toLowerCase();
                int lifespan = (int)(PotionProjectileMechanic.this.parseValues((LivingEntity)caster, PotionProjectileMechanic.LIFESPAN, level, 9999.0) * 20.0);
                int distance = (int)PotionProjectileMechanic.this.parseValues((LivingEntity)caster, PotionProjectileMechanic.DISTANCE, level, 50.0);
                Settings copy = new Settings(PotionProjectileMechanic.this.settings);
                copy.set(PotionProjectileMechanic.VELOCITY, PotionProjectileMechanic.this.parseValues((LivingEntity)caster, PotionProjectileMechanic.VELOCITY, level, 1.0), 0.0);
                copy.set("particles", PotionProjectileMechanic.this.parseValues((LivingEntity)caster, "particles", level, 1.0), 0.0);
                copy.set("radius", PotionProjectileMechanic.this.parseValues((LivingEntity)caster, "radius", level, 0.0), 0.0);
                copy.set("collision-radius", 0.125, 0.0);
                copy.set("gravity", -0.03, 0.0);
                copy.set("drag", 0.01, 0.0);
                copy.set("period", PotionProjectileMechanic.this.preview.getInt("path-steps", 2));
                ProjectileCallback callback = (projectile, hit) -> {
                    if (hit == null) {
                        hit = new TempEntity(projectile.getLocation());
                    }
                    ArrayList<LivingEntity> hitTargets = new ArrayList<LivingEntity>();
                    if (PotionProjectileMechanic.this.settings.getBool(PotionProjectileMechanic.LINGER, false)) {
                        double radius = PotionProjectileMechanic.this.parseValues((LivingEntity)caster, PotionProjectileMechanic.RADIUS, level, 3.0);
                        Location loc = projectile.getLocation();
                        hitTargets.addAll(Nearby.getLivingNearby(projectile.getLocation().getWorld(), new BoundingBox(loc.getX() - radius, loc.getY() + 0.6, loc.getZ() - radius, loc.getX() + radius, loc.getY() + 1.1, loc.getZ() + radius)));
                    }
                    if (hitTargets.isEmpty()) {
                        hitTargets.add(hit);
                    }
                    targets.addAll(hitTargets);
                    if (PotionProjectileMechanic.this.preview.getBool("per-target")) {
                        for (LivingEntity target : hitTargets) {
                            ParticleHelper.play(target.getLocation(), PotionProjectileMechanic.this.preview, Set.of(caster), "per-target-", PotionProjectileMechanic.this.preview.getBool("per-target-hitbox") ? target.getBoundingBox() : null);
                        }
                    }
                };
                ArrayList<ParticleProjectile> list = new ArrayList<ParticleProjectile>();
                for (LivingEntity target : (List)targetSupplier.get()) {
                    Location location = VectorUtil.getOffsetLocation(target, PotionProjectileMechanic.this.parseValues((LivingEntity)caster, PotionProjectileMechanic.FORWARD, level, 0.0), PotionProjectileMechanic.this.parseValues((LivingEntity)caster, PotionProjectileMechanic.RIGHT, level, 0.0), PotionProjectileMechanic.this.parseValues((LivingEntity)caster, PotionProjectileMechanic.UPWARD, level, 0.0));
                    if (spread.equals("rain")) {
                        list.addAll(ParticleProjectile.rain((LivingEntity)caster, level, location, copy, PotionProjectileMechanic.this.parseValues((LivingEntity)caster, PotionProjectileMechanic.RAIN_RADIUS, level, 2.0), PotionProjectileMechanic.this.parseValues((LivingEntity)caster, PotionProjectileMechanic.HEIGHT, level, 8.0), amount, callback, lifespan, distance));
                    } else {
                        Vector dir = location.getDirection();
                        if (spread.equals("horizontal cone")) {
                            dir.setY(0);
                            dir.normalize();
                        }
                        list.addAll(ParticleProjectile.spread((LivingEntity)caster, level, dir, location, copy, PotionProjectileMechanic.this.parseValues((LivingEntity)caster, PotionProjectileMechanic.ANGLE, level, 30.0), amount, callback, lifespan, distance));
                    }
                    for (ParticleProjectile p : list) {
                        Fabled.setMeta(p, "skill_level", level);
                        p.setAllyEnemy(true, true);
                    }
                    Consumer<Location> onStep = PotionProjectileMechanic.this.preview.getBool("path") ? loc -> new ParticleSettings(PotionProjectileMechanic.this.preview, "path-").instance(caster, loc.getX(), loc.getY(), loc.getZ()) : loc -> {};
                    for (ParticleProjectile p : list) {
                        p.setOnStep(onStep);
                    }
                    for (ParticleProjectile p : list) {
                        while (p.isValid()) {
                            p.run();
                        }
                    }
                }
            }
        }.runTaskTimer((Plugin)Fabled.inst(), 0L, (long)Math.max(1, this.preview.getInt("period", 5)));
        onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        this.playChildrenPreviews(onPreviewStop, caster, level, () -> targets);
    }
}

