/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.fabled.api.util.ItemStackReader;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class ArmorMechanic
extends MechanicComponent {
    private static final String SLOT = "slot";
    private static final String OVERWRITE = "overwrite";

    @Override
    public String getKey() {
        return "armor";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        EquipmentSlot slot;
        try {
            slot = EquipmentSlot.valueOf((String)this.settings.getString(SLOT, "HAND").toUpperCase(Locale.US).replace(" ", "_"));
        }
        catch (IllegalArgumentException exception) {
            return false;
        }
        ItemStack item = ItemStackReader.read(this.settings);
        boolean overwrite = this.settings.getBool(OVERWRITE, false);
        boolean success = false;
        for (LivingEntity target : targets) {
            EntityEquipment equipment = Objects.requireNonNull(target.getEquipment());
            boolean proceed = overwrite;
            if (!overwrite) {
                switch (slot) {
                    case FEET: {
                        proceed = equipment.getBoots().getType().equals((Object)Material.AIR);
                        break;
                    }
                    case HAND: {
                        proceed = equipment.getItemInMainHand().getType().equals((Object)Material.AIR);
                        break;
                    }
                    case HEAD: {
                        proceed = equipment.getHelmet().getType().equals((Object)Material.AIR);
                        break;
                    }
                    case LEGS: {
                        proceed = equipment.getLeggings().getType().equals((Object)Material.AIR);
                        break;
                    }
                    case CHEST: {
                        proceed = equipment.getChestplate().getType().equals((Object)Material.AIR);
                        break;
                    }
                    case OFF_HAND: {
                        proceed = equipment.getItemInOffHand().getType().equals((Object)Material.AIR);
                    }
                }
            }
            if (!proceed) continue;
            switch (slot) {
                case FEET: {
                    equipment.setBoots(item);
                    break;
                }
                case HAND: {
                    equipment.setItemInMainHand(item);
                    break;
                }
                case HEAD: {
                    equipment.setHelmet(item);
                    break;
                }
                case LEGS: {
                    equipment.setLeggings(item);
                    break;
                }
                case CHEST: {
                    equipment.setChestplate(item);
                    break;
                }
                case OFF_HAND: {
                    equipment.setItemInOffHand(item);
                }
            }
            success = true;
        }
        return success;
    }
}

