/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.custom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EditorOption {
    public final Type type;
    public final String key;
    public final String name;
    public final String description;
    public final Map<String, String> extra = new HashMap<String, String>();

    public static EditorOption number(String key, String name, String description, double base, double scale) {
        EditorOption option = new EditorOption(Type.NUMBER, key, name, description);
        option.extra.put("base", Double.toString(base));
        option.extra.put("scale", Double.toString(scale));
        return option;
    }

    public static EditorOption text(String key, String name, String description, String initial) {
        EditorOption option = new EditorOption(Type.TEXT, key, name, description);
        option.extra.put("default", "\"" + initial + "\"");
        return option;
    }

    public static EditorOption dropdown(String key, String name, String description, List<String> options) {
        EditorOption option = new EditorOption(Type.DROPDOWN, key, name, description);
        option.extra.put("options", EditorOption.format(options));
        return option;
    }

    public static EditorOption list(String key, String name, String description, List<String> options) {
        EditorOption option = new EditorOption(Type.LIST, key, name, description);
        option.extra.put("options", EditorOption.format(options));
        return option;
    }

    private static String format(List<String> list) {
        return "[\"" + list.stream().collect(Collectors.joining("\",\"")) + "\"]";
    }

    private EditorOption(Type type, String key, String name, String description) {
        this.type = type;
        this.key = key;
        this.name = name;
        this.description = description;
    }

    private static enum Type {
        NUMBER,
        TEXT,
        DROPDOWN,
        LIST;

    }
}

