/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.condition;

import org.bukkit.entity.LivingEntity;
import studio.magemonkey.fabled.dynamic.condition.ConditionComponent;

public class YawCondition
extends ConditionComponent {
    private static String MIN_YAW = "min-yaw";
    private static String MAX_YAW = "max-yaw";

    @Override
    boolean test(LivingEntity caster, int level, LivingEntity target) {
        double max;
        double min;
        double yaw = target.getLocation().getYaw();
        if (yaw < 0.0) {
            yaw += 360.0;
        }
        if ((min = this.settings.getDouble(MIN_YAW, 0.0)) < (max = this.settings.getDouble(MAX_YAW, 60.0))) {
            return yaw >= min && yaw <= max;
        }
        return yaw >= min || yaw <= max;
    }

    @Override
    public String getKey() {
        return "Yaw";
    }
}

