/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.condition;

import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.fabled.dynamic.condition.ConditionComponent;

public class WeatherCondition
extends ConditionComponent {
    private String TYPE = "type";

    @Override
    boolean test(LivingEntity caster, int level, LivingEntity target) {
        String type = this.settings.getString(this.TYPE).toLowerCase();
        World world = target.getWorld();
        Location loc = target.getLocation();
        double temperature = loc.getBlock().getTemperature();
        switch (type) {
            case "thunder": {
                return world.isThundering() && temperature <= 1.0;
            }
            case "rain": {
                return world.hasStorm() && temperature > 0.15 && temperature <= 1.0;
            }
            case "snow": {
                return world.hasStorm() && temperature <= 0.15;
            }
        }
        return !world.hasStorm() || temperature > 1.0;
    }

    @Override
    public String getKey() {
        return "weather";
    }
}

