/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cmd;

import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.player.PlayerSkillBar;

public class CmdBar
implements IFunction {
    private static final String NOT_PLAYER = "not-player";
    private static final String NO_CLASS = "no-class";
    private static final String IN_CREATIVE = "in-creative";
    private static final String NO_SPACE = "no-space";
    private static final String TOGGLE_ON = "toggle-on";
    private static final String TOGGLE_OFF = "toggle-off";
    private static final String DISABLED = "world-disabled";

    public void execute(ConfigurableCommand command, Plugin plugin, CommandSender sender, String[] args, boolean silent) {
        if (!(sender instanceof Player)) {
            command.sendMessage(sender, NOT_PLAYER, "&4Only players can use this command", silent, new CustomFilter[0]);
            return;
        }
        if (!Fabled.getSettings().isWorldEnabled(((Player)sender).getWorld())) {
            command.sendMessage(sender, DISABLED, "&4You cannot use this command in this world", silent, new CustomFilter[0]);
            return;
        }
        PlayerData player = Fabled.getData((OfflinePlayer)((Player)sender));
        if (!player.hasClass()) {
            command.sendMessage(sender, NO_CLASS, "&4You have not professed as any class yet", silent, new CustomFilter[0]);
        } else if (player.getPlayer().getGameMode() == GameMode.CREATIVE) {
            command.sendMessage(sender, IN_CREATIVE, "&4You cannot be in creative mode", silent, new CustomFilter[0]);
        } else {
            PlayerSkillBar bar = player.getSkillBar();
            if (!bar.isEnabled() && bar.countOpenSlots() < bar.getItemsInSkillSlots()) {
                command.sendMessage(sender, NO_SPACE, "&4You don't have enough inventory space for the skill bar", silent, new CustomFilter[0]);
                return;
            }
            bar.toggleEnabled();
            if (bar.isEnabled()) {
                command.sendMessage(sender, TOGGLE_ON, "&2Your skill bar has been &6enabled", silent, new CustomFilter[0]);
            } else {
                command.sendMessage(sender, TOGGLE_OFF, "&2Your skill bar has been &2disabled", silent, new CustomFilter[0]);
            }
        }
    }
}

