/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cast;

import java.util.ArrayList;
import java.util.Collections;
import lombok.Generated;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.player.PlayerSkill;

public class PlayerTextCastingData {
    private final PlayerData player;
    private final String[] skills = new String[9];
    private boolean casting = false;
    private int oldSlot;

    public PlayerTextCastingData(PlayerData data) {
        this.player = data;
    }

    public void load(DataSection config) {
        if (config == null) {
            return;
        }
        for (int i = 0; i < this.skills.length; ++i) {
            String skillName = config.getString(String.valueOf(i));
            this.remove(skillName);
            this.skills[i] = skillName;
            this.validate();
        }
    }

    public void validate() {
        for (int i = 0; i < this.skills.length; ++i) {
            if (this.isValid(this.skills[i])) continue;
            this.skills[i] = null;
        }
        int castSlot = Fabled.getSettings().getCastSlot();
        if (this.skills[castSlot] != null) {
            int i;
            ArrayList list = new ArrayList(10);
            Collections.addAll(list, this.skills);
            for (i = 0; i < list.size(); ++i) {
                if (i == castSlot || list.get(i) != null) continue;
                list.remove(i);
                break;
            }
            if (list.size() == 9) {
                list.set(castSlot, null);
            } else {
                list.add(castSlot, null);
            }
            for (i = 0; i < this.skills.length; ++i) {
                this.skills[i] = (String)list.get(i);
            }
        }
    }

    public void save(DataSection config) {
        for (int i = 0; i < this.skills.length; ++i) {
            if (this.skills[i] == null) continue;
            config.set(String.valueOf(i), (Object)this.skills[i]);
        }
    }

    private void remove(String skillName) {
        if (skillName == null) {
            return;
        }
        for (int i = 0; i < this.skills.length; ++i) {
            if (this.skills[i] == null || !this.skills[i].equalsIgnoreCase(skillName)) continue;
            this.skills[i] = null;
        }
    }

    public boolean isEmpty() {
        for (String skill : this.skills) {
            if (skill == null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public String getSkill(int slot) {
        String skill = this.skills[slot];
        if (this.isValid(skill)) {
            return skill;
        }
        this.skills[slot] = null;
        return null;
    }

    public void assign(@Nullable String skillName, int slot) {
        if (!this.isValid(skillName)) {
            return;
        }
        if (slot == Fabled.getSettings().getCastSlot()) {
            return;
        }
        this.remove(skillName);
        this.skills[slot] = skillName;
    }

    private boolean isValid(@Nullable String skillName) {
        if (skillName == null) {
            return true;
        }
        if (!this.player.hasSkill(skillName)) {
            return false;
        }
        PlayerSkill playerSkill = this.player.getSkill(skillName);
        return playerSkill != null && playerSkill.isUnlocked() && playerSkill.getData().canCast();
    }

    public boolean onUnlock(String skillName) {
        if (skillName == null || !this.isValid(skillName)) {
            return false;
        }
        for (String skill : this.skills) {
            if (skill == null || !skill.equalsIgnoreCase(skillName)) continue;
            return false;
        }
        for (int i = 0; i < this.skills.length; ++i) {
            if (i == Fabled.getSettings().getCastSlot() || this.skills[i] != null) continue;
            this.assign(skillName, i);
            return true;
        }
        return false;
    }

    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        String skillFormat = StringUT.color((String)Fabled.getSettings().getMessageFormatSkill());
        String separator = StringUT.color((String)Fabled.getSettings().getMessageFormatSeparator());
        boolean first = true;
        for (int i = 0; i < 9; ++i) {
            String skill = this.getSkill(i);
            if (skill == null) continue;
            if (first) {
                first = false;
            } else {
                stringBuilder.append(separator);
            }
            stringBuilder.append(skillFormat.replace("%number%", String.valueOf(i + 1)).replace("%skill%", skill));
        }
        return stringBuilder.toString();
    }

    public void setCasting(boolean casting) {
        this.casting = casting;
        PlayerInventory inventory = this.player.getPlayer().getInventory();
        if (casting) {
            this.oldSlot = inventory.getHeldItemSlot();
            inventory.setHeldItemSlot(Fabled.getSettings().getCastSlot());
        } else {
            inventory.setHeldItemSlot(this.oldSlot);
        }
    }

    public boolean cast(int slot) {
        PlayerSkill skill = this.player.getSkill(this.skills[slot]);
        if (skill != null) {
            return this.player.cast(skill);
        }
        return false;
    }

    @Generated
    public boolean isCasting() {
        return this.casting;
    }
}

