/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cast;

import java.util.ArrayList;
import lombok.Generated;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.player.PlayerSkill;

public class PlayerCastWheel {
    private final PlayerData player;
    private final ArrayList<PlayerSkill> skills = new ArrayList();
    private boolean casting = false;
    private int index;

    public PlayerCastWheel(PlayerData data) {
        this.player = data;
        this.index = 0;
        for (PlayerSkill skill : data.getSkills()) {
            if (!skill.getData().canCast() || !skill.isUnlocked()) continue;
            this.skills.add(skill);
        }
    }

    public void validate(PlayerData data) {
        this.skills.clear();
        for (PlayerSkill skill : data.getSkills()) {
            if (!skill.getData().canCast() || !skill.isUnlocked()) continue;
            this.skills.add(skill);
        }
    }

    public void unlock(PlayerSkill skill) {
        if (skill.isUnlocked() && skill.getData().canCast()) {
            this.skills.add(skill);
        }
    }

    public void remove(PlayerSkill skill) {
        this.skills.remove(skill);
    }

    public boolean isEmpty() {
        return this.skills.isEmpty();
    }

    public int wheelSize() {
        return this.skills.size();
    }

    public String getMessage() {
        int size = this.skills.size();
        if (size == 0) {
            return "";
        }
        int currentIndex = this.index % size;
        if (currentIndex < 0) {
            currentIndex += size;
        }
        String selectedSkill = StringUT.color((String)Fabled.getSettings().getWheelFormatSelectedSkill());
        String unselectedSkill = StringUT.color((String)Fabled.getSettings().getWheelFormatUnselectedSkill());
        String previousSeparator = StringUT.color((String)Fabled.getSettings().getWheelFormatPreviousSeparator());
        String nextSeparator = StringUT.color((String)Fabled.getSettings().getWheelFormatNextSeparator());
        int prevIndex = (currentIndex - 1 + size) % size;
        int nextIndex = (currentIndex + 1) % size;
        StringBuilder stringBuilder = new StringBuilder();
        if (size > 1) {
            stringBuilder.append(unselectedSkill.replace("%number%", String.valueOf(prevIndex + 1)).replace("%skill%", this.skills.get(prevIndex).getData().getName())).append(previousSeparator);
        }
        stringBuilder.append(selectedSkill.replace("%number%", String.valueOf(currentIndex + 1)).replace("%skill%", this.skills.get(currentIndex).getData().getName()));
        if (size > 1) {
            stringBuilder.append(nextSeparator).append(unselectedSkill.replace("%number%", String.valueOf(nextIndex + 1)).replace("%skill%", this.skills.get(nextIndex).getData().getName()));
        }
        return stringBuilder.toString();
    }

    public void cast() {
        if (!this.skills.isEmpty()) {
            this.player.cast(this.skills.get(this.index));
        }
    }

    public void nextSkill() {
        if (!this.skills.isEmpty()) {
            this.index = (this.index + 1) % this.skills.size();
        }
    }

    public void previousSkill() {
        if (!this.skills.isEmpty()) {
            this.index = (this.index + this.skills.size() - 1) % this.skills.size();
        }
    }

    @Generated
    public boolean isCasting() {
        return this.casting;
    }

    @Generated
    public void setCasting(boolean casting) {
        this.casting = casting;
    }
}

