/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.BoundingBox;

public class Nearby {
    public static List<Entity> getNearby(Location loc, double radius) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        int minX = (int)(loc.getX() - radius) >> 4;
        int maxX = (int)(loc.getX() + radius) >> 4;
        int minZ = (int)(loc.getZ() - radius) >> 4;
        int maxZ = (int)(loc.getZ() + radius) >> 4;
        radius *= radius;
        for (int i = minX; i <= maxX; ++i) {
            for (int j = minZ; j <= maxZ; ++j) {
                for (Entity entity : loc.getWorld().getChunkAt(i, j).getEntities()) {
                    if (!(entity.getLocation().distanceSquared(loc) < radius)) continue;
                    result.add(entity);
                }
            }
        }
        return result;
    }

    public static List<LivingEntity> getLivingNearby(Location loc, double radius) {
        return Nearby.getLivingNearby(null, loc, radius, false);
    }

    public static List<LivingEntity> getLivingNearby(Location loc, double radius, boolean includeCaster) {
        return Nearby.getLivingNearby(null, loc, radius, includeCaster);
    }

    public static List<LivingEntity> getLivingNearby(World world, BoundingBox boundingBox) {
        return Nearby.getLivingNearby(null, world, boundingBox, false);
    }

    public static List<LivingEntity> getLivingNearby(World world, BoundingBox boundingBox, boolean includeCaster) {
        return Nearby.getLivingNearby(null, world, boundingBox, includeCaster);
    }

    private static List<LivingEntity> getLivingNearby(Entity source, Location loc, double radius, boolean includeCaster) {
        ArrayList<LivingEntity> result = new ArrayList<LivingEntity>();
        HashMap<UUID, Double> distances = new HashMap<UUID, Double>();
        int minX = (int)(loc.getX() - radius) >> 4;
        int maxX = (int)(loc.getX() + radius) >> 4;
        int minZ = (int)(loc.getZ() - radius) >> 4;
        int maxZ = (int)(loc.getZ() + radius) >> 4;
        radius *= radius;
        World world = Objects.requireNonNull(loc.getWorld());
        for (int i = minX; i <= maxX; ++i) {
            for (int j = minZ; j <= maxZ; ++j) {
                for (Entity entity2 : world.getChunkAt(i, j).getEntities()) {
                    if (!includeCaster && entity2 == source || !(entity2 instanceof LivingEntity) || entity2.getWorld() != loc.getWorld() || !(entity2.getLocation().distanceSquared(loc) < radius)) continue;
                    result.add((LivingEntity)entity2);
                    distances.put(entity2.getUniqueId(), entity2.getLocation().distanceSquared(loc));
                }
            }
        }
        return result.stream().sorted(Comparator.comparingDouble(entity -> (Double)distances.get(entity.getUniqueId()))).collect(Collectors.toList());
    }

    private static List<LivingEntity> getLivingNearby(Entity source, World world, BoundingBox boundingBox, boolean includeCaster) {
        ArrayList<LivingEntity> result = new ArrayList<LivingEntity>();
        HashMap<UUID, Double> distances = new HashMap<UUID, Double>();
        int minX = (int)boundingBox.getMinX() >> 4;
        int maxX = (int)boundingBox.getMaxX() >> 4;
        int minZ = (int)boundingBox.getMinZ() >> 4;
        int maxZ = (int)boundingBox.getMaxZ() >> 4;
        Location loc = boundingBox.getCenter().toLocation(world);
        for (int i = minX; i <= maxX; ++i) {
            for (int j = minZ; j <= maxZ; ++j) {
                for (Entity entity2 : world.getChunkAt(i, j).getEntities()) {
                    if (!includeCaster && entity2 == source || !(entity2 instanceof LivingEntity) || entity2.getWorld() != world || !entity2.getBoundingBox().overlaps(boundingBox)) continue;
                    result.add((LivingEntity)entity2);
                    distances.put(entity2.getUniqueId(), entity2.getLocation().distanceSquared(loc));
                }
            }
        }
        return result.stream().sorted(Comparator.comparingDouble(entity -> (Double)distances.get(entity.getUniqueId()))).collect(Collectors.toList());
    }

    public static List<Entity> getNearby(Entity entity, double radius) {
        return Nearby.getNearby(entity.getLocation(), radius);
    }

    public static List<LivingEntity> getLivingNearby(Entity entity, double radius) {
        return Nearby.getLivingNearby(entity, entity.getLocation(), radius, false);
    }

    public static List<LivingEntity> getLivingNearby(Entity entity, double radius, boolean includeCaster) {
        return Nearby.getLivingNearby(entity, entity.getLocation(), radius, includeCaster);
    }

    public static List<Entity> getNearbyBox(Location loc, double radius) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        int minX = (int)(loc.getX() - radius) >> 4;
        int maxX = (int)(loc.getX() + radius) >> 4;
        int minZ = (int)(loc.getZ() - radius) >> 4;
        int maxZ = (int)(loc.getZ() + radius) >> 4;
        for (int i = minX; i <= maxX; ++i) {
            for (int j = minZ; j <= maxZ; ++j) {
                for (Entity entity : loc.getWorld().getChunkAt(i, j).getEntities()) {
                    if (!(Nearby.boxDistance(entity.getLocation(), loc) < radius)) continue;
                    result.add(entity);
                }
            }
        }
        return result;
    }

    public static List<LivingEntity> getLivingNearbyBox(Location loc, double radius) {
        ArrayList<LivingEntity> result = new ArrayList<LivingEntity>();
        int minX = (int)(loc.getX() - radius) >> 4;
        int maxX = (int)(loc.getX() + radius) >> 4;
        int minZ = (int)(loc.getZ() - radius) >> 4;
        int maxZ = (int)(loc.getZ() + radius) >> 4;
        for (int i = minX; i <= maxX; ++i) {
            for (int j = minZ; j <= maxZ; ++j) {
                for (Entity entity : loc.getWorld().getChunkAt(i, j).getEntities()) {
                    if (!(entity instanceof LivingEntity) || !(Nearby.boxDistance(entity.getLocation(), loc) < radius)) continue;
                    result.add((LivingEntity)entity);
                }
            }
        }
        return result;
    }

    private static double boxDistance(Location loc1, Location loc2) {
        return Math.max(Math.max(Math.abs(loc1.getX() - loc2.getX()), Math.abs(loc1.getY() - loc2.getY())), Math.abs(loc1.getZ() - loc2.getZ()));
    }
}

