/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.codex.registry.provider.BuffProvider;
import studio.magemonkey.fabled.api.util.Buff;
import studio.magemonkey.fabled.api.util.BuffData;
import studio.magemonkey.fabled.api.util.BuffType;

public class BuffManager
implements BuffProvider {
    private static BuffManager instance;
    private final Map<UUID, BuffData> data = new HashMap<UUID, BuffData>();

    public static BuffManager getInstance() {
        if (instance == null) {
            instance = new BuffManager();
        }
        return instance;
    }

    public static BuffData getBuffData(LivingEntity entity) {
        return BuffManager.getBuffData(entity, true);
    }

    public static BuffData getBuffData(LivingEntity entity, boolean create) {
        if (entity == null) {
            return null;
        }
        Map<UUID, BuffData> data = BuffManager.getInstance().getData();
        if (!data.containsKey(entity.getUniqueId()) && create) {
            data.put(entity.getUniqueId(), new BuffData(entity));
        }
        return data.get(entity.getUniqueId());
    }

    public static void clearData(LivingEntity entity) {
        if (entity == null) {
            return;
        }
        Map<UUID, BuffData> data = BuffManager.getInstance().getData();
        BuffData result = data.remove(entity.getUniqueId());
        if (result != null) {
            result.clear();
        }
    }

    public static void addBuff(LivingEntity entity, BuffType type, Buff buff, int ticks) {
        if (entity == null) {
            return;
        }
        BuffManager.getBuffData(entity, true).addBuff(type, buff, ticks);
    }

    public static void addBuff(LivingEntity entity, BuffType type, String category, Buff buff, int ticks) {
        if (entity == null) {
            return;
        }
        BuffManager.getBuffData(entity, true).addBuff(type.getLocalizedName(), category, buff, ticks);
    }

    @Deprecated
    public static void addDamageBuff(LivingEntity entity, Buff buff, int ticks) {
        BuffManager.addBuff(entity, BuffType.DAMAGE, buff, ticks);
    }

    @Deprecated
    public static void addDefenseBuff(LivingEntity entity, Buff buff, int ticks) {
        BuffManager.addBuff(entity, BuffType.DEFENSE, buff, ticks);
    }

    @Deprecated
    public static void addSkillDamageBuff(LivingEntity entity, Buff buff, int ticks) {
        BuffManager.addBuff(entity, BuffType.SKILL_DAMAGE, buff, ticks);
    }

    @Deprecated
    public static void addSkillDefenseBuff(LivingEntity entity, Buff buff, int ticks) {
        BuffManager.addBuff(entity, BuffType.SKILL_DEFENSE, buff, ticks);
    }

    @Deprecated(forRemoval=true, since="1.0.4-R0.16-SNAPSHOT")
    public static double apply(LivingEntity entity, BuffType type, double amount) {
        return BuffManager.getInstance().scaleValue(type.getLocalizedName(), entity, amount);
    }

    @Deprecated(forRemoval=true, since="1.0.4-R0.16-SNAPSHOT")
    public static double apply(LivingEntity entity, BuffType type, String category, double amount) {
        return BuffManager.getInstance().scaleValue(type.getLocalizedName() + (String)(category == null ? "" : "_" + category), entity, amount);
    }

    public double scaleValue(String name, LivingEntity player, double value) {
        BuffData data = BuffManager.getBuffData(player, false);
        if (data != null) {
            return data.apply(name, value);
        }
        return value;
    }

    @Deprecated
    public static double modifyDealtDamage(LivingEntity entity, double damage) {
        return BuffManager.apply(entity, BuffType.DAMAGE, damage);
    }

    @Deprecated
    public static double modifyTakenDefense(LivingEntity entity, double damage) {
        return BuffManager.apply(entity, BuffType.DEFENSE, damage);
    }

    @Deprecated
    public static double modifySkillDealtDamage(LivingEntity entity, double damage) {
        return BuffManager.apply(entity, BuffType.SKILL_DAMAGE, damage);
    }

    @Deprecated
    public static double modifySkillTakenDefense(LivingEntity entity, double damage) {
        return BuffManager.apply(entity, BuffType.SKILL_DEFENSE, damage);
    }

    @Generated
    public Map<UUID, BuffData> getData() {
        return this.data;
    }
}

