/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.scheduler.BukkitRunnable;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.event.BuffExpiredEvent;
import studio.magemonkey.fabled.api.util.Buff;
import studio.magemonkey.fabled.api.util.BuffManager;
import studio.magemonkey.fabled.api.util.BuffType;
import studio.magemonkey.fabled.log.LogType;
import studio.magemonkey.fabled.log.Logger;

public class BuffData {
    private final Map<String, Map<String, Buff>> buffs = new HashMap<String, Map<String, Buff>>();
    private final LivingEntity entity;

    public BuffData(LivingEntity entity) {
        this.entity = entity;
    }

    public double getMultiplier(BuffType buffType, String category) {
        return category == null || category.isEmpty() ? this.getMultiplier(buffType.getLocalizedName()) : this.getMultiplier(buffType.getLocalizedName(), buffType.getLocalizedName() + "_" + category);
    }

    public double getFlatBonus(BuffType buffType, String category) {
        return category == null || category.isEmpty() ? this.getFlatBonus(buffType.getLocalizedName()) : this.getFlatBonus(buffType.getLocalizedName(), buffType.getLocalizedName() + "_" + category);
    }

    @Deprecated
    public void addBuff(BuffType type, Buff buff, int ticks) {
        this.addBuff(type.getLocalizedName(), buff, ticks);
    }

    public void addBuff(String type, Buff buff, int ticks) {
        this.doAddBuff(type, buff, ticks);
    }

    @Deprecated
    public void addBuff(BuffType type, String category, Buff buff, int ticks) {
        this.addBuff(type.getLocalizedName(), category, buff, ticks);
    }

    public void addBuff(String type, String category, Buff buff, int ticks) {
        this.doAddBuff(type + (String)(category != null ? "_" + category : ""), buff, ticks);
    }

    private void doAddBuff(String type, Buff buff, int ticks) {
        Map typeBuffs = this.buffs.computeIfAbsent(type, t -> new HashMap());
        Buff conflict = (Buff)typeBuffs.remove(buff.getKey());
        if (conflict != null) {
            conflict.task.cancel();
        }
        typeBuffs.put(buff.getKey(), buff);
        buff.task = Fabled.schedule(new BuffTask(type, buff.getKey()), ticks);
    }

    @Deprecated
    public void addDamageBuff(Buff buff, int ticks) {
        this.addBuff(BuffType.DAMAGE.getLocalizedName(), buff, ticks);
    }

    @Deprecated
    public void addDefenseBuff(Buff buff, int ticks) {
        this.addBuff(BuffType.DEFENSE.getLocalizedName(), buff, ticks);
    }

    @Deprecated
    public void addSkillDamageBuff(Buff buff, int ticks) {
        this.addBuff(BuffType.SKILL_DAMAGE.getLocalizedName(), buff, ticks);
    }

    @Deprecated
    public void addSkillDefenseBuff(Buff buff, int ticks) {
        this.addBuff(BuffType.SKILL_DEFENSE.getLocalizedName(), buff, ticks);
    }

    public double apply(String type, double value) {
        return this.doApply(value, type);
    }

    @Deprecated
    public double apply(BuffType type, double value) {
        return this.apply(type.getLocalizedName(), value);
    }

    public boolean isActive(BuffType type) {
        Map<String, Buff> typeBuffs = this.buffs.get(type.getLocalizedName());
        return typeBuffs != null;
    }

    public void clearByType(BuffType type) {
        Map<String, Buff> buffType = this.buffs.get(type.getLocalizedName());
        if (buffType == null) {
            return;
        }
        for (Buff buff : buffType.values()) {
            buff.task.cancel();
        }
        this.buffs.remove(type.getLocalizedName());
    }

    public double apply(BuffType type, String category, double value) {
        return category == null || category.isEmpty() ? this.doApply(value, type.getLocalizedName()) : this.doApply(value, type.getLocalizedName(), type.getLocalizedName() + "_" + category);
    }

    private double doApply(double value, String ... types) {
        if (value <= 0.0) {
            return value;
        }
        double multiplier = 1.0;
        double bonus = 0.0;
        Logger.log(LogType.BUFF, 1, "Buffs:");
        for (String type : types) {
            Map<String, Buff> typeBuffs = this.buffs.get(type);
            if (typeBuffs == null) continue;
            for (Buff buff : typeBuffs.values()) {
                if (buff.isPercent()) {
                    Logger.log(LogType.BUFF, 1, "  - x" + buff.getValue());
                    multiplier *= buff.getValue();
                    continue;
                }
                Logger.log(LogType.BUFF, 1, "  - +" + buff.getValue());
                bonus += buff.getValue();
            }
        }
        double result = Math.max(0.0, value * multiplier + bonus);
        Logger.log(LogType.BUFF, 1, "Result: x" + multiplier + ", +" + bonus + ", " + value + " -> " + result);
        if (multiplier <= 0.0) {
            return 0.0;
        }
        return result;
    }

    private double getFlatBonus(String ... types) {
        double bonus = 0.0;
        for (String type : types) {
            for (Buff buff : this.buffs.getOrDefault(type, Collections.emptyMap()).values()) {
                if (buff.isPercent()) continue;
                bonus += buff.getValue();
            }
        }
        return bonus;
    }

    private double getMultiplier(String ... types) {
        double multiplier = 1.0;
        for (String type : types) {
            for (Buff buff : this.buffs.getOrDefault(type, Collections.emptyMap()).values()) {
                if (!buff.isPercent()) continue;
                multiplier *= buff.getValue();
            }
        }
        return Math.max(0.0, multiplier);
    }

    @Deprecated
    public double modifyDealtDamage(double damage) {
        return this.apply(BuffType.DAMAGE.getLocalizedName(), damage);
    }

    @Deprecated
    public double modifyTakenDamage(double damage) {
        return this.apply(BuffType.DEFENSE.getLocalizedName(), damage);
    }

    @Deprecated
    public double modifySkillDealtDamage(double damage) {
        return this.apply(BuffType.SKILL_DAMAGE.getLocalizedName(), damage);
    }

    @Deprecated
    public double modifySkillTakenDamage(double damage) {
        return this.apply(BuffType.SKILL_DEFENSE.getLocalizedName(), damage);
    }

    public void clear() {
        for (Map<String, Buff> typeBuffs : this.buffs.values()) {
            for (Buff buff : typeBuffs.values()) {
                buff.task.cancel();
            }
        }
        this.buffs.clear();
        BuffManager.clearData(this.entity);
    }

    private class BuffTask
    extends BukkitRunnable {
        private final String type;
        private final String key;

        BuffTask(String type, String key) {
            this.type = type;
            this.key = key;
        }

        public void run() {
            if (!BuffData.this.entity.isValid() || BuffData.this.entity.isDead()) {
                BuffManager.clearData(BuffData.this.entity);
                return;
            }
            Map<String, Buff> typeBuffs = BuffData.this.buffs.get(this.type);
            typeBuffs.remove(this.key);
            if (typeBuffs.isEmpty()) {
                BuffData.this.buffs.remove(this.type);
                if (BuffData.this.buffs.isEmpty()) {
                    BuffManager.clearData(BuffData.this.entity);
                }
            }
            BuffExpiredEvent event = new BuffExpiredEvent(BuffData.this.entity, typeBuffs.get(this.type), this.type);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
    }
}

