/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api.particle.direction;

import studio.magemonkey.fabled.api.particle.direction.DirectionHandler;
import studio.magemonkey.fabled.data.Matrix3D;
import studio.magemonkey.fabled.data.Point2D;
import studio.magemonkey.fabled.data.Point3D;

public class XZHandler
implements DirectionHandler {
    public static XZHandler instance = new XZHandler();

    @Override
    public void apply(Point3D point, double n1, double n2) {
        point.x = n1;
        point.y = 0.0;
        point.z = n2;
    }

    @Override
    public double rotateX(Point3D p, Point2D trig) {
        return p.x * trig.x - p.z * trig.y;
    }

    public Point3D rotateAboutY(Point3D p, Matrix3D matrix) {
        double x = matrix.getX1() * p.x + matrix.getY1() * p.y + matrix.getZ1() * p.z;
        double y = matrix.getX2() * p.x + matrix.getY2() * p.y + matrix.getZ2() * p.z;
        double z = matrix.getX3() * p.x + matrix.getY3() * p.y + matrix.getZ3() * p.z;
        return new Point3D(x, y, z);
    }

    public Point3D rotateAboutY(Point3D p, double rads) {
        double sin = Math.sin(rads);
        double cos = Math.cos(rads);
        double x = p.x;
        double y = p.y;
        double z = p.z;
        double newX = cos * x + sin * z;
        double newY = y;
        double newZ = -sin * x + cos * z;
        Point3D ret = new Point3D(newX, newY, newZ);
        return ret;
    }

    @Override
    public double rotateY(Point3D p, Point2D trig) {
        return p.y;
    }

    @Override
    public double rotateZ(Point3D p, Point2D trig) {
        return p.x * trig.y + p.z * trig.x;
    }
}

