/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api.particle;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.codex.mccore.config.CommentedConfig;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.codex.util.FileUT;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.particle.EffectData;
import studio.magemonkey.fabled.api.particle.EffectInstance;
import studio.magemonkey.fabled.api.particle.IParticleEffect;
import studio.magemonkey.fabled.api.particle.PolarSettings;
import studio.magemonkey.fabled.api.particle.direction.XZHandler;
import studio.magemonkey.fabled.api.particle.target.EffectTarget;
import studio.magemonkey.fabled.api.particle.target.EntityTarget;
import studio.magemonkey.fabled.task.EffectTask;
import studio.magemonkey.fabled.thread.MainThread;

public class EffectManager {
    private static Map<EffectTarget, EffectData> instances = new ConcurrentHashMap<EffectTarget, EffectData>();
    private static Map<String, IParticleEffect> effects = new HashMap<String, IParticleEffect>();
    private static Map<String, PolarSettings> formulas = new HashMap<String, PolarSettings>();

    public static void init() {
        CommentedConfig config = Fabled.getConfig("effects");
        config.saveDefaultConfig();
        DataSection data = config.getConfig();
        for (String key : data.keys()) {
            formulas.put(key, new PolarSettings(data.getSection(key)));
            if (!key.equals("one-circle")) continue;
            formulas.get(key).getPoints(XZHandler.instance);
        }
        try {
            File imagesDir = new File(Fabled.inst().getDataFolder(), "images");
            if (!imagesDir.exists() && imagesDir.mkdirs()) {
                FileUT.copy((InputStream)Objects.requireNonNull(Fabled.inst().getResource("images/default.png")), (File)new File(imagesDir, "default.png"));
            }
        }
        catch (Exception e) {
            Fabled.inst().getLogger().warning("Failed to create images directory: " + e.getMessage());
        }
        MainThread.register(new EffectTask());
    }

    public static void cleanUp() {
        formulas.clear();
        effects.clear();
        instances.clear();
    }

    public static void register(IParticleEffect effect) {
        if (effect != null) {
            effects.put(effect.getName(), effect);
        }
    }

    public static void register(String key, PolarSettings formula) {
        if (formula != null) {
            formulas.put(key, formula);
        }
    }

    public static PolarSettings getFormula(String key) {
        return formulas.get(key);
    }

    public static IParticleEffect getEffect(String name) {
        return effects.get(name);
    }

    public static void clear(EffectTarget target) {
        instances.remove(target);
    }

    public static void clear(LivingEntity target) {
        instances.entrySet().removeIf(entry -> entry.getKey() instanceof EntityTarget && ((EntityTarget)entry.getKey()).getEntity() == target);
    }

    public static EffectData getEffectData(EffectTarget target) {
        return instances.get(target);
    }

    public static EffectInstance getEffect(EffectTarget target, String key) {
        if (!instances.containsKey(target)) {
            return null;
        }
        return instances.get(target).getEffect(key);
    }

    public static void runEffect(IParticleEffect effect, EffectTarget target, int ticks, int level) {
        if (!instances.containsKey(target)) {
            instances.put(target, new EffectData(target));
        }
        instances.get(target).runEffect(effect, ticks, level);
    }

    public static void tick() {
        Iterator<EffectData> iterator = instances.values().iterator();
        while (iterator.hasNext()) {
            EffectData data = iterator.next();
            if (data.isValid()) {
                data.tick();
                continue;
            }
            iterator.remove();
        }
    }
}

