/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api.armorstand;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.fabled.api.armorstand.ArmorStandInstance;

public class ArmorStandData {
    private final HashMap<String, ArmorStandInstance> armorStands = new HashMap();
    private final LivingEntity target;

    public ArmorStandData(LivingEntity target) {
        this.target = target;
    }

    public boolean isValid() {
        return this.armorStands.size() > 0 && this.target.isValid();
    }

    public ArmorStandInstance getArmorStands(String key) {
        return this.armorStands.get(key);
    }

    public void register(ArmorStandInstance armorStand, String key) {
        ArmorStandInstance oldArmorStand = this.armorStands.put(key, armorStand);
        if (oldArmorStand != null) {
            oldArmorStand.remove();
        }
    }

    public void tick() {
        Iterator<ArmorStandInstance> iterator = this.armorStands.values().iterator();
        while (iterator.hasNext()) {
            ArmorStandInstance armorStand = iterator.next();
            if (armorStand.isValid()) {
                armorStand.tick();
                continue;
            }
            armorStand.remove();
            iterator.remove();
        }
    }

    public String getKey(ArmorStandInstance armorStand) {
        for (Map.Entry<String, ArmorStandInstance> entry : this.armorStands.entrySet()) {
            String key = entry.getKey();
            ArmorStandInstance value = entry.getValue();
            if (value != armorStand) continue;
            return key;
        }
        return null;
    }

    public void remove() {
        this.armorStands.values().forEach(ArmorStandInstance::remove);
        this.armorStands.clear();
    }

    public void remove(String key) {
        ArmorStandInstance armorStand = this.armorStands.get(key);
        if (armorStand != null) {
            armorStand.remove();
        }
        this.armorStands.remove(key);
    }

    public void remove(ArmorStandInstance armorStand) {
        armorStand.remove();
        String key = this.getKey(armorStand);
        if (key != null) {
            this.armorStands.remove(key);
        }
    }
}

