/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.codex.mccore.config.parse.NumberParser;
import studio.magemonkey.fabled.log.Logger;

public class Settings {
    private static final String BASE = "-base";
    private static final String SCALE = "-scale";
    private final HashMap<String, Object> settings;

    public Settings() {
        this.settings = new LinkedHashMap<String, Object>();
    }

    public Settings(Settings settings) {
        this.settings = new HashMap<String, Object>(settings.settings);
    }

    public void set(String key, Object value) {
        if (value == null) {
            this.settings.remove(key);
        } else {
            this.settings.put(key, value);
        }
    }

    public void set(String key, double base, double scale) {
        this.set(key + BASE, base);
        this.set(key + SCALE, scale);
    }

    public void setBase(String key, double value) {
        if (!this.settings.containsKey(key + SCALE) || this.settings.get(key + SCALE) == null) {
            this.set(key + SCALE, 0.0);
        }
        this.set(key + BASE, value);
    }

    public void setScale(String key, double value) {
        if (!this.settings.containsKey(key + BASE) || this.settings.get(key + BASE) == null) {
            this.set(key + BASE, 0.0);
        }
        this.set(key + SCALE, value);
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        if (this.settings.containsKey(key) && this.settings.get(key) != null) {
            return NumberParser.parseDouble((String)this.settings.get(key).toString());
        }
        this.set(key, defaultValue);
        return defaultValue;
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultValue) {
        if (this.settings.containsKey(key) && this.settings.get(key) != null) {
            return Float.parseFloat(this.settings.get(key).toString());
        }
        this.set(key, Float.valueOf(defaultValue));
        return defaultValue;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        if (this.settings.containsKey(key) && this.settings.get(key) != null) {
            return Integer.parseInt(this.settings.get(key).toString());
        }
        this.set(key, defaultValue);
        return defaultValue;
    }

    public boolean getBool(String key) {
        return this.settings.containsKey(key) && this.settings.get(key) != null && Boolean.parseBoolean(this.settings.get(key).toString());
    }

    public boolean getBool(String key, boolean defaultValue) {
        if (this.settings.containsKey(key) && this.settings.get(key) != null) {
            return Boolean.parseBoolean(this.settings.get(key).toString());
        }
        this.set(key, defaultValue);
        return defaultValue;
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        if (this.settings.containsKey(key) && this.settings.get(key) != null) {
            return this.settings.get(key).toString();
        }
        this.set(key, defaultValue);
        return defaultValue;
    }

    public List<String> getStringList(String key) {
        if (this.settings.containsKey(key) && this.settings.get(key) != null) {
            Object value = this.settings.get(key);
            if (value instanceof List) {
                return (List)this.settings.get(key);
            }
            if (value.toString().equals("[]")) {
                return new ArrayList<String>();
            }
            return ImmutableList.of((Object)value.toString());
        }
        return new ArrayList<String>();
    }

    public double getAttr(String key, int level) {
        return this.getAttr(key, level, 0.0);
    }

    public double getAttr(String key, int level, double defaultValue) {
        if (!this.has(key)) {
            this.set(key, defaultValue, 0.0);
            return defaultValue;
        }
        return this.getBase(key) + this.getScale(key) * (double)(level - 1);
    }

    public double getBase(String key) {
        if (!this.settings.containsKey(key + BASE) || this.settings.get(key + BASE) == null) {
            return 0.0;
        }
        return NumberParser.parseDouble((String)this.settings.get(key + BASE).toString());
    }

    public double getScale(String key) {
        if (!this.settings.containsKey(key + SCALE) || this.settings.get(key + SCALE) == null) {
            return 0.0;
        }
        return NumberParser.parseDouble((String)this.settings.get(key + SCALE).toString());
    }

    public Object getObj(String key, int level) {
        if (this.settings.containsKey(key) && this.settings.get(key) != null) {
            return this.settings.get(key);
        }
        if (this.settings.containsKey(key + BASE) && this.settings.get(key + BASE) != null) {
            return this.getAttr(key, level);
        }
        return 0;
    }

    public boolean has(String key) {
        return this.settings.containsKey(key) && this.settings.get(key) != null || this.settings.containsKey(key + BASE) && this.settings.get(key + BASE) != null;
    }

    public void remove(String key) {
        this.settings.remove(key);
        this.settings.remove(key + BASE);
        this.settings.remove(key + SCALE);
    }

    public void checkDefault(String key, double defaultBase, double defaultScale) {
        if (!this.has(key)) {
            this.set(key, defaultBase, defaultScale);
        }
    }

    public void save(DataSection config) {
        if (config == null) {
            return;
        }
        for (String key : this.settings.keySet()) {
            config.set(key, this.settings.get(key));
        }
    }

    public void load(DataSection config) {
        if (config == null) {
            return;
        }
        for (String key : config.keys()) {
            this.set(key, config.get(key));
        }
    }

    public void dumpToConsole() {
        Logger.log("Settings:");
        for (String key : this.settings.keySet()) {
            Logger.log("- " + key + ": " + this.settings.get(key).toString());
        }
    }
}

