/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.CombatProtection;
import studio.magemonkey.fabled.api.player.PlayerClass;
import studio.magemonkey.fabled.hook.NoCheatHook;
import studio.magemonkey.fabled.hook.PluginChecker;

public class DefaultCombatProtection
implements CombatProtection {
    public static final Set<EntityDamageByEntityEvent> fakeDamageEvents = new HashSet<EntityDamageByEntityEvent>();
    public static final Map<EntityDamageByEntityEvent, Boolean> externallyCancelled = new HashMap<EntityDamageByEntityEvent, Boolean>();

    public static boolean isFakeDamageEvent(EntityDamageByEntityEvent event) {
        return fakeDamageEvents.contains(event);
    }

    public static boolean isExternallyCancelled(EntityDamageByEntityEvent event) {
        return externallyCancelled.getOrDefault(event, false);
    }

    @Override
    public boolean canAttack(LivingEntity attacker, LivingEntity defender, EntityDamageEvent.DamageCause cause) {
        boolean canAttack;
        if (attacker instanceof Player && defender instanceof Player) {
            PlayerClass attackerClass = Fabled.getData((OfflinePlayer)((Player)attacker)).getMainClass();
            PlayerClass defenderClass = Fabled.getData((OfflinePlayer)((Player)defender)).getMainClass();
            int attackerLevel = attackerClass == null ? 0 : attackerClass.getLevel();
            int defenderLevel = defenderClass == null ? 0 : defenderClass.getLevel();
            int minLevel = Fabled.getSettings().getPvpMinLevel();
            if (attackerLevel < minLevel || defenderLevel < minLevel) {
                return false;
            }
            int levelRange = Fabled.getSettings().getPvpLevelRange();
            if (levelRange > -1 && Math.abs(attackerLevel - defenderLevel) > levelRange) {
                return false;
            }
        }
        if (PluginChecker.isNoCheatActive() && attacker instanceof Player) {
            Player player = (Player)attacker;
            NoCheatHook.exempt(player);
            canAttack = CombatProtection.canAttack(attacker, defender);
            NoCheatHook.unexempt(player);
        } else {
            canAttack = CombatProtection.canAttack(attacker, defender, false, cause);
        }
        return canAttack;
    }
}

