/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Tameable;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.DefaultCombatProtection;

public interface CombatProtection {
    public static boolean canAttack(LivingEntity attacker, LivingEntity target, boolean passiveAlly) {
        return CombatProtection.canAttack(attacker, target, passiveAlly, EntityDamageEvent.DamageCause.CUSTOM);
    }

    public static boolean canAttack(LivingEntity attacker, LivingEntity target, boolean passiveAlly, EntityDamageEvent.DamageCause cause) {
        OfflinePlayer owner;
        Tameable entity;
        if (attacker == target) {
            return false;
        }
        if (attacker instanceof Tameable && (entity = (Tameable)target).isTamed() && entity.getOwner() instanceof OfflinePlayer && (owner = (OfflinePlayer)entity.getOwner()).isOnline()) {
            attacker = owner.getPlayer();
        }
        if (target instanceof Tameable) {
            entity = (Tameable)target;
            if (entity.isTamed() && entity.getOwner() instanceof OfflinePlayer && (owner = (OfflinePlayer)entity.getOwner()).isOnline()) {
                return CombatProtection.canAttack(attacker, (LivingEntity)owner.getPlayer(), false);
            }
        } else if (passiveAlly && target instanceof Animals) {
            return false;
        }
        return CombatProtection.canAttackExternally((Entity)attacker, (Entity)target, cause);
    }

    public static boolean canAttack(LivingEntity attacker, LivingEntity defender) {
        return CombatProtection.canAttack(attacker, defender, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canAttackExternally(@NotNull Entity damager, @NotNull Entity entity, @NotNull EntityDamageEvent.DamageCause cause) {
        EntityDamageByEntityEvent event = VersionManager.getNms().createEntityDamageEvent(entity, damager, cause, 5.0);
        DefaultCombatProtection.fakeDamageEvents.add(event);
        boolean externallyCancelled = false;
        try {
            Bukkit.getPluginManager().callEvent((Event)event);
            externallyCancelled = DefaultCombatProtection.isExternallyCancelled(event);
        }
        catch (Exception e) {
            Fabled.inst().getLogger().warning("Failed to process EntityDamageByEntityEvent");
            e.printStackTrace();
        }
        finally {
            DefaultCombatProtection.fakeDamageEvents.remove(event);
            DefaultCombatProtection.externallyCancelled.remove(event);
        }
        return !externallyCancelled;
    }

    public boolean canAttack(LivingEntity var1, LivingEntity var2, EntityDamageEvent.DamageCause var3);
}

